/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.db;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.kie.test.util.db.DataSourceFactory;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtil {
    private static Logger logger = LoggerFactory.getLogger(PersistenceUtil.class);
    public static final String ENTITY_MANAGER_FACTORY = "org.kie.api.persistence.jpa.EntityManagerFactory";
    public static final String TRANSACTION_MANAGER = "java:comp/TransactionManager";
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private static H2Server h2Server = new H2Server();
    private static Properties defaultProperties = null;
    public static String DATASOURCE = "org.droolsjbpm.persistence.datasource";

    public static Map<String, Object> setupWithPoolingDataSource(String persistenceUnitName) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, true);
    }

    public static Map<String, Object> setupWithPoolingDataSource(String persistenceUnitName, boolean testMarshalling) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, "jdbc/testDS1", testMarshalling);
    }

    public static Map<String, Object> setupWithPoolingDataSource(String persistenceUnitName, String dataSourceName, boolean testMarshalling) {
        PoolingDataSourceWrapper ds1 = PersistenceUtil.setupPoolingDataSource(PersistenceUtil.getDatasourceProperties(), dataSourceName);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(DATASOURCE, ds1);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        context.put(ENTITY_MANAGER_FACTORY, emf);
        return context;
    }

    public static void cleanUp(Map<String, Object> context) {
        if (context != null) {
            Object ds1Object;
            Object emfObject = context.remove(ENTITY_MANAGER_FACTORY);
            if (emfObject != null) {
                try {
                    EntityManagerFactory emf = (EntityManagerFactory)emfObject;
                    emf.close();
                }
                catch (Throwable t) {
                    logger.error("Exception", t);
                }
            }
            if ((ds1Object = context.remove(DATASOURCE)) != null) {
                try {
                    PoolingDataSourceWrapper ds1 = (PoolingDataSourceWrapper)ds1Object;
                    ds1.close();
                }
                catch (Throwable t) {
                    logger.error("Exception", t);
                }
            }
        }
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource() {
        return PersistenceUtil.setupPoolingDataSource(PersistenceUtil.getDatasourceProperties());
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(Properties dsProps) {
        String datasourceName = dsProps.getProperty("datasourceName", "jdbc/testDS1");
        return PersistenceUtil.setupPoolingDataSource(dsProps, datasourceName);
    }

    public static PoolingDataSourceWrapper setupPoolingDataSource(Properties dsProps, String datasourceName) {
        String driverClass = dsProps.getProperty("driverClassName");
        if (driverClass.startsWith("org.h2")) {
            String jdbcUrl = dsProps.getProperty("url");
            if (jdbcUrl.startsWith("jdbc:h2:") && !jdbcUrl.contains("tcp://") && !jdbcUrl.contains("mem:")) {
                dsProps.put("url", jdbcUrl + "tcp://localhost/target/./persistence-test");
            }
            h2Server.start(dsProps.getProperty("h2Args"));
        }
        return DataSourceFactory.setupPoolingDataSource(datasourceName, dsProps);
    }

    private static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", "url", "user", "password", "driverClassName", "className", "maxPoolSize", "allowLocalTransactions"};
            String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:tcp://localhost/JPADroolsFlow", "sa", "", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "16", "true"};
            if (keyArr.length != defaultPropArr.length) {
                throw new IllegalStateException("Unequal number of keys for default properties!");
            }
            defaultProperties = new Properties();
            for (int i = 0; i < keyArr.length; ++i) {
                defaultProperties.put(keyArr[i], defaultPropArr[i]);
            }
        }
        return defaultProperties;
    }

    public static Properties getDatasourceProperties() {
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        if (propsInputStream == null) {
            throw new IllegalStateException(propertiesNotFoundMessage);
        }
        Properties props = new Properties();
        try {
            props.load(propsInputStream);
        }
        catch (IOException ioe) {
            propertiesNotFound = true;
            logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
            logger.error("Exception", (Throwable)ioe);
        }
        String password = props.getProperty("password");
        if ("${maven.jdbc.password}".equals(password) || propertiesNotFound) {
            props = PersistenceUtil.getDefaultProperties();
        }
        return props;
    }

    public static boolean useTransactions() {
        boolean useTransactions = false;
        String databaseDriverClassName = PersistenceUtil.getDatasourceProperties().getProperty("driverClassName");
        if (databaseDriverClassName.startsWith("org.postgresql") || databaseDriverClassName.startsWith("com.edb")) {
            useTransactions = true;
        }
        return useTransactions;
    }

    private static class H2Server {
        private Server realH2Server;

        private H2Server() {
        }

        public void start(String h2Args) {
            System.out.println("running H2 server");
            if (this.realH2Server == null || !this.realH2Server.isRunning(false)) {
                try {
                    DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
                    this.realH2Server = Server.createTcpServer((String[])this.parseArgs(h2Args));
                    this.realH2Server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Can't start h2 server db", e);
                }
            }
        }

        private String[] parseArgs(String args) {
            if (args == null || args.trim().isEmpty()) {
                return new String[0];
            }
            return args.trim().split("\\s+");
        }

        protected void finalize() throws Throwable {
            if (this.realH2Server != null) {
                this.realH2Server.stop();
            }
            DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
            super.finalize();
        }
    }
}

