/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.kie.test.util.filesystem.ResourceHelper;

public class FileUtils {
    private FileUtils() {
    }

    public static File getFile(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        File toReturn = ResourceHelper.getResourcesByExtension(extension).filter(file -> file.getName().equals(fileName)).findFirst().orElse(null);
        Assert.assertNotNull((Object)toReturn);
        return toReturn;
    }

    public static FileInputStream getFileInputStream(String fileName) throws IOException {
        File sourceFile = FileUtils.getFile(fileName);
        return new FileInputStream(sourceFile);
    }

    public static String getFileContent(String fileName) throws IOException {
        File file = FileUtils.getFile(fileName);
        Path path = file.toPath();
        Stream<String> lines = Files.lines(path);
        String toReturn = lines.collect(Collectors.joining("\n"));
        lines.close();
        return toReturn;
    }
}

