/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.db.internal;

import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.tomcat.dbcp.dbcp2.managed.BasicManagedDataSource;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.kie.test.util.db.internal.DatabaseProvider;
import org.kie.test.util.db.internal.PoolingDataSourceFactory;

public final class PoolingDataSourceWrapperImpl
implements PoolingDataSourceWrapper {
    private static final Logger logger = Logger.getLogger(PoolingDataSourceWrapperImpl.class.getSimpleName());
    private Properties driverProperties;
    private String uniqueName;
    private String className;
    private BasicManagedDataSource managedDataSource;
    private DatabaseProvider databaseProvider;

    public PoolingDataSourceWrapperImpl(String uniqueName, String dsClassName, Properties driverProperties) {
        this(uniqueName, dsClassName, driverProperties, new Properties());
    }

    public PoolingDataSourceWrapperImpl(String uniqueName, String dsClassName, Properties driverProperties, Properties poolingProperties) {
        this.uniqueName = uniqueName;
        this.className = dsClassName;
        this.driverProperties = this.copy(driverProperties);
        this.databaseProvider = DatabaseProvider.fromDriverClassName(this.className);
        XADataSource xaDataSource = this.createXaDataSource();
        TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
        TransactionSynchronizationRegistry tsr = jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistry();
        this.managedDataSource = (BasicManagedDataSource)PoolingDataSourceFactory.createPoolingDataSource(tm, xaDataSource, tsr, this.copy(poolingProperties));
        try {
            InitialContext initContext = new InitialContext();
            initContext.rebind(uniqueName, (Object)this.managedDataSource);
            initContext.rebind("java:comp/UserTransaction", (Object)UserTransaction.userTransaction());
            initContext.rebind("java:comp/TransactionManager", (Object)tm);
            initContext.rebind("java:comp/TransactionSynchronizationRegistry", (Object)tsr);
        }
        catch (NamingException e) {
            logger.warning("No InitialContext available, resource won't be accessible via lookup");
        }
    }

    private Properties copy(Properties props) {
        Properties copiedProperties = new Properties();
        copiedProperties.putAll((Map<?, ?>)props);
        return copiedProperties;
    }

    private XADataSource createXaDataSource() {
        XADataSource xaDataSource;
        try {
            xaDataSource = (XADataSource)Class.forName(this.className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        if (this.databaseProvider == DatabaseProvider.H2) {
            this.invokeMethodOnXADataSource(xaDataSource, "setUser", this.getUsernameFromDriverProperties());
            this.invokeMethodOnXADataSource(xaDataSource, "setPassword", this.getPasswordFromDriverProperties());
        }
        if (this.databaseProvider != DatabaseProvider.DB2 && this.databaseProvider != DatabaseProvider.SYBASE) {
            this.setupUrlOnXADataSource(xaDataSource);
        } else {
            this.invokeMethodOnXADataSource(xaDataSource, "setServerName", this.driverProperties.getProperty("serverName"));
            this.invokeMethodOnXADataSource(xaDataSource, "setDatabaseName", this.driverProperties.getProperty("databaseName"));
            if (this.databaseProvider == DatabaseProvider.DB2) {
                this.invokeMethodOnXADataSource(xaDataSource, "setDriverType", 4);
                this.invokeMethodOnXADataSource(xaDataSource, "setPortNumber", Integer.valueOf(this.driverProperties.getProperty("portNumber")));
                this.invokeMethodOnXADataSource(xaDataSource, "setResultSetHoldability", Integer.valueOf(this.driverProperties.getProperty("ResultSetHoldability")));
                this.invokeMethodOnXADataSource(xaDataSource, "setDowngradeHoldCursorsUnderXa", Boolean.parseBoolean("DowngradeHoldCursorsUnderXa"));
            } else if (this.databaseProvider == DatabaseProvider.SYBASE) {
                this.invokeMethodOnXADataSource(xaDataSource, "setPortNumber", Integer.valueOf(this.driverProperties.getProperty("portNumber")));
                this.invokeMethodOnXADataSource(xaDataSource, "setPassword", this.driverProperties.getProperty("password"));
                this.invokeMethodOnXADataSource(xaDataSource, "setUser", this.driverProperties.getProperty("user"));
            }
        }
        return xaDataSource;
    }

    private void setupUrlOnXADataSource(XADataSource xaDataSource) {
        String url = this.driverProperties.getProperty("url", this.driverProperties.getProperty("URL"));
        try {
            this.invokeMethodOnXADataSource(xaDataSource, "setUrl", url);
        }
        catch (UnsupportedOperationException outerException) {
            logger.info("Unable to find \"setUrl\" method in db driver JAR. Trying \"setURL\" ");
            try {
                this.invokeMethodOnXADataSource(xaDataSource, "setURL", url);
            }
            catch (UnsupportedOperationException innerException) {
                logger.info("Driver does not support setURL and setUrl method.");
                throw innerException;
            }
        }
    }

    private void invokeMethodOnXADataSource(XADataSource dataSource, String methodName, Object parameter) {
        try {
            dataSource.getClass().getMethod(methodName, parameter.getClass()).invoke((Object)dataSource, parameter);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new UnsupportedOperationException("Unable to invoke method \"" + methodName + "\" on XADataSource.");
        }
    }

    private String getUsernameFromDriverProperties() {
        return this.driverProperties.getProperty("user");
    }

    private String getPasswordFromDriverProperties() {
        return this.driverProperties.getProperty("password");
    }

    @Override
    public void close() {
        try {
            this.managedDataSource.close();
            new InitialContext().unbind(this.uniqueName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.managedDataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.managedDataSource.getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.managedDataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.managedDataSource.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.managedDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.managedDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.managedDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.managedDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.managedDataSource.getParentLogger();
    }
}

