/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.db;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceUtil {
    private static Logger logger = LoggerFactory.getLogger(PersistenceUtil.class);
    public static final String ENTITY_MANAGER_FACTORY = "org.kie.api.persistence.jpa.EntityManagerFactory";
    public static final String TRANSACTION_MANAGER = "TRANSACTION_MANAGER";
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    private static H2Server h2Server = new H2Server();
    private static Properties defaultProperties = null;
    public static String DATASOURCE = "org.droolsjbpm.persistence.datasource";

    public static Map<String, Object> setupWithPoolingDataSource(String persistenceUnitName) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, true);
    }

    public static Map<String, Object> setupWithPoolingDataSource(String persistenceUnitName, boolean testMarshalling) {
        return PersistenceUtil.setupWithPoolingDataSource(persistenceUnitName, "jdbc/testDS1", testMarshalling);
    }

    public static Map<String, Object> setupWithPoolingDataSource(String persistenceUnitName, String dataSourceName, boolean testMarshalling) {
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        String jdbcUrl = dsProps.getProperty("url");
        String driverClass = dsProps.getProperty("driverClassName");
        PoolingDataSource ds1 = PersistenceUtil.setupPoolingDataSource(dsProps, dataSourceName);
        if (driverClass.startsWith("org.h2")) {
            jdbcUrl = jdbcUrl + "tcp://localhost/target/persistence-test";
            ds1.getDriverProperties().setProperty("url", jdbcUrl);
        }
        ds1.init();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(DATASOURCE, ds1);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        context.put(ENTITY_MANAGER_FACTORY, emf);
        context.put(TRANSACTION_MANAGER, TransactionManagerServices.getTransactionManager());
        return context;
    }

    public static void cleanUp(Map<String, Object> context) {
        if (context != null) {
            Object ds1Object;
            Object emfObject;
            BitronixTransactionManager txm = TransactionManagerServices.getTransactionManager();
            if (txm != null) {
                txm.shutdown();
            }
            if ((emfObject = context.remove(ENTITY_MANAGER_FACTORY)) != null) {
                try {
                    EntityManagerFactory emf = (EntityManagerFactory)emfObject;
                    emf.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if ((ds1Object = context.remove(DATASOURCE)) != null) {
                try {
                    PoolingDataSource ds1 = (PoolingDataSource)ds1Object;
                    ds1.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static PoolingDataSource setupPoolingDataSource(Properties dsProps) {
        return PersistenceUtil.setupPoolingDataSource(dsProps, "jdbc/testDS1");
    }

    public static PoolingDataSource setupPoolingDataSource(Properties dsProps, String datasourceName) {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName(datasourceName);
        pds.setClassName(dsProps.getProperty("className"));
        pds.setMaxPoolSize(Integer.parseInt(dsProps.getProperty("maxPoolSize")));
        pds.setAllowLocalTransactions(Boolean.parseBoolean(dsProps.getProperty("allowLocalTransactions")));
        for (String propertyName : new String[]{"user", "password"}) {
            pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
        }
        String driverClass = dsProps.getProperty("driverClassName");
        if (driverClass.startsWith("org.h2")) {
            h2Server.start();
            for (String propertyName : new String[]{"url", "driverClassName"}) {
                pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
            }
        } else {
            pds.setClassName(dsProps.getProperty("className"));
            if (driverClass.startsWith("oracle")) {
                pds.getDriverProperties().put("driverType", "thin");
                pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
            } else if (driverClass.startsWith("com.ibm.db2")) {
                pds.getDriverProperties().put("databaseName", dsProps.getProperty("databaseName"));
                pds.getDriverProperties().put("driverType", "4");
                pds.getDriverProperties().put("serverName", dsProps.getProperty("serverName"));
                pds.getDriverProperties().put("portNumber", dsProps.getProperty("portNumber"));
                pds.getDriverProperties().put("currentSchema", dsProps.getProperty("defaultSchema"));
            } else if (driverClass.startsWith("com.microsoft")) {
                for (String propertyName : new String[]{"serverName", "portNumber", "databaseName"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
                pds.getDriverProperties().put("URL", dsProps.getProperty("url"));
                pds.getDriverProperties().put("selectMethod", "cursor");
                pds.getDriverProperties().put("InstanceName", "MSSQL01");
            } else if (driverClass.startsWith("com.mysql")) {
                for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else if (driverClass.startsWith("org.mariadb")) {
                for (String propertyName : new String[]{"databaseName", "serverName", "portNumber", "url"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else if (driverClass.startsWith("com.sybase")) {
                for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
                pds.getDriverProperties().put("REQUEST_HA_SESSION", "false");
                pds.getDriverProperties().put("networkProtocol", "Tds");
            } else if (driverClass.startsWith("org.postgresql") || driverClass.startsWith("com.edb")) {
                for (String propertyName : new String[]{"databaseName", "portNumber", "serverName"}) {
                    pds.getDriverProperties().put(propertyName, dsProps.getProperty(propertyName));
                }
            } else {
                throw new RuntimeException("Unknown driver class: " + driverClass);
            }
        }
        return pds;
    }

    private static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", "url", "user", "password", "driverClassName", "className", "maxPoolSize", "allowLocalTransactions"};
            String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:tcp://localhost/JPADroolsFlow", "sa", "", "org.h2.Driver", "bitronix.tm.resource.jdbc.lrc.LrcXADataSource", "16", "true"};
            Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
            defaultProperties = new Properties();
            for (int i = 0; i < keyArr.length; ++i) {
                defaultProperties.put(keyArr[i], defaultPropArr[i]);
            }
        }
        return defaultProperties;
    }

    public static Properties getDatasourceProperties() {
        String password;
        String propertiesNotFoundMessage = "Unable to load datasource properties [/datasource.properties]";
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = PersistenceUtil.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        Assert.assertNotNull((String)propertiesNotFoundMessage, (Object)propsInputStream);
        Properties props = new Properties();
        if (propsInputStream != null) {
            try {
                props.load(propsInputStream);
            }
            catch (IOException ioe) {
                propertiesNotFound = true;
                logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        } else {
            propertiesNotFound = true;
        }
        if ("${maven.jdbc.password}".equals(password = props.getProperty("password")) || propertiesNotFound) {
            props = PersistenceUtil.getDefaultProperties();
        }
        return props;
    }

    public static boolean useTransactions() {
        boolean useTransactions = false;
        String databaseDriverClassName = PersistenceUtil.getDatasourceProperties().getProperty("driverClassName");
        if (databaseDriverClassName.startsWith("org.postgresql")) {
            useTransactions = true;
        }
        return useTransactions;
    }

    private static class H2Server {
        private Server realH2Server;

        private H2Server() {
        }

        public void start() {
            if (this.realH2Server == null || !this.realH2Server.isRunning(false)) {
                try {
                    DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
                    this.realH2Server = Server.createTcpServer((String[])new String[0]);
                    this.realH2Server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Can't start h2 server db", e);
                }
            }
        }

        protected void finalize() throws Throwable {
            if (this.realH2Server != null) {
                this.realH2Server.stop();
            }
            DeleteDbFiles.execute((String)"", (String)"JPADroolsFlow", (boolean)true);
            super.finalize();
        }
    }
}

