/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.model;

import java.util.List;
import java.util.Map;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.models.scorecard.model.KiePMMLComplexPartialScore;

public class KiePMMLAttribute
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = 2996541076370981543L;
    private final KiePMMLPredicate predicate;
    private KiePMMLComplexPartialScore complexPartialScore;
    private String reasonCode = null;
    private Number partialScore = null;

    private KiePMMLAttribute(String name, List<KiePMMLExtension> extensions, KiePMMLPredicate predicate) {
        super(name, extensions);
        this.predicate = predicate;
    }

    public Number evaluate(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, Map<String, Object> inputData) {
        if (!this.predicate.evaluate(inputData)) {
            return null;
        }
        return this.complexPartialScore != null ? (Number)this.complexPartialScore.evaluate(defineFunctions, derivedFields, outputFields, inputData) : (Number)this.partialScore;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, KiePMMLPredicate predicate) {
        return new Builder(name, extensions, predicate);
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLAttribute> {
        private Builder(String name, List<KiePMMLExtension> extensions, KiePMMLPredicate predicate) {
            super("Attribute-", () -> new KiePMMLAttribute(name, extensions, predicate));
        }

        public Builder withComplexPartialScore(KiePMMLComplexPartialScore complexPartialScore) {
            if (complexPartialScore != null) {
                ((KiePMMLAttribute)this.toBuild).complexPartialScore = complexPartialScore;
            }
            return this;
        }

        public Builder withReasonCode(String reasonCode) {
            if (reasonCode != null) {
                ((KiePMMLAttribute)this.toBuild).reasonCode = reasonCode;
            }
            return this;
        }

        public Builder withPartialScore(Number partialScore) {
            if (partialScore != null) {
                ((KiePMMLAttribute)this.toBuild).partialScore = partialScore;
            }
            return this;
        }
    }
}

