/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.model;

import java.util.List;
import java.util.Map;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.models.scorecard.model.KiePMMLAttribute;

public class KiePMMLCharacteristic
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = 3302920103976105622L;
    private final List<KiePMMLAttribute> attributes;
    private String reasonCode = null;
    private Number baselineScore = null;

    private KiePMMLCharacteristic(String name, List<KiePMMLExtension> extensions, List<KiePMMLAttribute> attributes) {
        super(name, extensions);
        this.attributes = attributes;
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, List<KiePMMLAttribute> attributes) {
        return new Builder(name, extensions, attributes);
    }

    public Number getBaselineScore() {
        return this.baselineScore;
    }

    public ReasonCodeValue evaluate(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, Map<String, Object> inputData) {
        for (KiePMMLAttribute attribute : this.attributes) {
            Number attributeScore = attribute.evaluate(defineFunctions, derivedFields, outputFields, inputData);
            if (attributeScore == null) continue;
            String totalReasonCode = attribute.getReasonCode() != null ? attribute.getReasonCode() : this.reasonCode;
            return new ReasonCodeValue(totalReasonCode, attributeScore);
        }
        return null;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLCharacteristic> {
        private Builder(String name, List<KiePMMLExtension> extensions, List<KiePMMLAttribute> attributes) {
            super("Characteristic-", () -> new KiePMMLCharacteristic(name, extensions, attributes));
        }

        public Builder withReasonCode(String reasonCode) {
            if (reasonCode != null) {
                ((KiePMMLCharacteristic)this.toBuild).reasonCode = reasonCode;
            }
            return this;
        }

        public Builder withBaselineScore(Number baselineScore) {
            if (baselineScore != null) {
                ((KiePMMLCharacteristic)this.toBuild).baselineScore = baselineScore;
            }
            return this;
        }
    }

    public static class ReasonCodeValue {
        private final String reasonCode;
        private final Number score;

        public ReasonCodeValue(String reasonCode, Number score) {
            this.reasonCode = reasonCode;
            this.score = score;
        }

        public String getReasonCode() {
            return this.reasonCode;
        }

        public Number getScore() {
            return this.score;
        }
    }
}

