/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.model;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;

public class KiePMMLComplexPartialScore
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = 3456691439946792947L;
    private final KiePMMLExpression expression;

    public KiePMMLComplexPartialScore(String name, List<KiePMMLExtension> extensions, KiePMMLExpression expression) {
        super(name, extensions);
        this.expression = expression;
    }

    public Number evaluate(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, Map<String, Object> inputData) {
        List<KiePMMLNameValue> kiePMMLNameValues = KiePMMLComplexPartialScore.getKiePMMLNameValuesFromInputDataMap(inputData);
        ProcessingDTO processingDTO = new ProcessingDTO(defineFunctions, derivedFields, outputFields, kiePMMLNameValues);
        Object toReturn = this.expression.evaluate(processingDTO);
        return toReturn != null ? (Number)((Number)toReturn) : (Number)null;
    }

    static List<KiePMMLNameValue> getKiePMMLNameValuesFromInputDataMap(Map<String, Object> inputData) {
        return inputData.entrySet().stream().map(entry -> new KiePMMLNameValue((String)entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }
}

