/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.transformations.KiePMMLDefineFunction;
import org.kie.pmml.commons.transformations.KiePMMLDerivedField;
import org.kie.pmml.models.scorecard.model.KiePMMLCharacteristic;

public class KiePMMLCharacteristics
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = 2399787298848608820L;
    protected final List<KiePMMLCharacteristic> characteristics;

    public KiePMMLCharacteristics(String name, List<KiePMMLExtension> extensions, List<KiePMMLCharacteristic> characteristics) {
        super(name, extensions);
        this.characteristics = characteristics;
    }

    public static Number addNumbers(Number a, Number b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.doubleValue() + b.doubleValue();
    }

    public static Number calculatePartialScore(Number baselineScore, Number partialScore, REASONCODE_ALGORITHM reasoncodeAlgorithm) {
        if (baselineScore == null && partialScore == null) {
            return null;
        }
        if (baselineScore == null) {
            return partialScore;
        }
        if (partialScore == null) {
            return baselineScore;
        }
        switch (reasoncodeAlgorithm) {
            case POINTS_BELOW: {
                return baselineScore.doubleValue() - partialScore.doubleValue();
            }
            case POINTS_ABOVE: {
                return partialScore.doubleValue() - baselineScore.doubleValue();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown REASONCODE_ALGORITHM %s", reasoncodeAlgorithm));
    }

    public Optional<Number> evaluate(List<KiePMMLDefineFunction> defineFunctions, List<KiePMMLDerivedField> derivedFields, List<KiePMMLOutputField> outputFields, Map<String, Object> inputData, Map<String, Object> outputFieldsMap, Number initialScore, REASONCODE_ALGORITHM reasoncodeAlgorithm, boolean useReasonCodes, Number baselineScore) {
        Number accumulator = null;
        for (KiePMMLCharacteristic characteristic : this.characteristics) {
            KiePMMLCharacteristic.ReasonCodeValue evaluation = characteristic.evaluate(defineFunctions, derivedFields, outputFields, inputData);
            if (evaluation == null) continue;
            Number evaluationScore = evaluation.getScore();
            if (accumulator == null) {
                accumulator = initialScore != null ? (Number)initialScore : (Number)0;
            }
            accumulator = KiePMMLCharacteristics.addNumbers(accumulator, evaluationScore);
            if (!useReasonCodes || evaluation.getReasonCode() == null) continue;
            this.populateReasonCodes(evaluation, characteristic, reasoncodeAlgorithm, outputFieldsMap, baselineScore);
        }
        return Optional.ofNullable(accumulator);
    }

    private void populateReasonCodes(KiePMMLCharacteristic.ReasonCodeValue evaluation, KiePMMLCharacteristic characteristic, REASONCODE_ALGORITHM reasoncodeAlgorithm, Map<String, Object> outputFieldsMap, Number baselineScore) {
        Number baselineScoreToUse = characteristic.getBaselineScore() != null ? (Number)characteristic.getBaselineScore() : (Number)baselineScore;
        Number rankingScore = KiePMMLCharacteristics.calculatePartialScore(baselineScoreToUse, evaluation.getScore(), reasoncodeAlgorithm);
        outputFieldsMap.put(evaluation.getReasonCode(), rankingScore);
    }
}

