/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;

public class KiePMMLCharacteristics
extends AbstractKiePMMLComponent {
    private static final long serialVersionUID = 2399787298848608820L;

    public static Number addNumbers(Number a, Number b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.doubleValue() + b.doubleValue();
    }

    public static Number calculatePartialScore(Number baselineScore, Number partialScore, REASONCODE_ALGORITHM reasoncodeAlgorithm) {
        if (baselineScore == null && partialScore == null) {
            return null;
        }
        if (baselineScore == null) {
            return partialScore;
        }
        if (partialScore == null) {
            return baselineScore;
        }
        switch (reasoncodeAlgorithm) {
            case POINTS_BELOW: {
                return baselineScore.doubleValue() - partialScore.doubleValue();
            }
            case POINTS_ABOVE: {
                return partialScore.doubleValue() - baselineScore.doubleValue();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown REASONCODE_ALGORITHM %s", reasoncodeAlgorithm));
    }

    protected KiePMMLCharacteristics(String modelName) {
        super(modelName, Collections.emptyList());
    }

    protected static Optional<Number> getCharacteristicsScore(List<BiFunction<Map<String, Object>, Map<String, Object>, Number>> characteristicFunctions, Map<String, Object> requestData, Map<String, Object> outputFieldsMap, Number initialScore) {
        Number accumulator = null;
        for (BiFunction<Map<String, Object>, Map<String, Object>, Number> function : characteristicFunctions) {
            Number evaluation = function.apply(requestData, outputFieldsMap);
            if (evaluation == null) continue;
            if (accumulator == null) {
                accumulator = initialScore != null ? (Number)initialScore : (Number)0;
            }
            accumulator = KiePMMLCharacteristics.addNumbers(accumulator, evaluation);
        }
        return Optional.ofNullable(accumulator);
    }
}

