/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.models.scorecard.model.KiePMMLCharacteristics;

public class KiePMMLCharacteristic
extends AbstractKiePMMLComponent {
    protected KiePMMLCharacteristic(String modelName) {
        super(modelName, Collections.emptyList());
    }

    public static Optional<Number> getCharacteristicScore(List<BiFunction<Map<String, Object>, Map<String, Object>, Number>> attributeFunctions, Map<String, Object> requestData, Map<String, Object> outputFieldsMap, String reasonCode, Number baseScore, REASONCODE_ALGORITHM reasoncodeAlgorithm) {
        Optional<Number> toReturn = Optional.empty();
        for (BiFunction<Map<String, Object>, Map<String, Object>, Number> function : attributeFunctions) {
            Number evaluation = function.apply(requestData, outputFieldsMap);
            if (evaluation != null) {
                toReturn = Optional.ofNullable(evaluation);
                if (reasonCode != null) {
                    Number rankingScore = KiePMMLCharacteristics.calculatePartialScore(baseScore, evaluation, reasoncodeAlgorithm);
                    outputFieldsMap.put(reasonCode, rankingScore);
                }
            }
            if (!toReturn.isPresent()) continue;
            break;
        }
        return toReturn;
    }
}

