/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler.executor;

import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.scorecard.Scorecard;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.models.scorecard.compiler.factories.KiePMMLScorecardModelFactory;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModel;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModelWithSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScorecardModelImplementationProvider
implements ModelImplementationProvider<Scorecard, KiePMMLScorecardModel> {
    private static final Logger logger = LoggerFactory.getLogger((String)ScorecardModelImplementationProvider.class.getName());

    public PMML_MODEL getPMMLModelType() {
        logger.trace("getPMMLModelType");
        return PMML_MODEL.SCORECARD_MODEL;
    }

    public KiePMMLScorecardModel getKiePMMLModel(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, Scorecard model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModel {} {} {} {}", new Object[]{packageName, fields, model, hasClassloader});
        return KiePMMLScorecardModelFactory.getKiePMMLScorecardModel(fields, transformationDictionary, model, packageName, hasClassloader);
    }

    public KiePMMLScorecardModel getKiePMMLModelWithSources(String packageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, Scorecard model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModelWithSources {} {} {} {}", new Object[]{packageName, fields, model, hasClassloader});
        try {
            Map<String, String> sourcesMap = KiePMMLScorecardModelFactory.getKiePMMLScorecardModelSourcesMap(fields, transformationDictionary, model, packageName);
            return new KiePMMLScorecardModelWithSources(model.getModelName(), packageName, sourcesMap);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }
}

