/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.scorecard.Scorecard;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.kie.pmml.models.scorecard.compiler.factories.KiePMMLCharacteristicsFactory;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLScorecardModelFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLScorecardModelFactory.class.getName());
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA = "KiePMMLScorecardModelTemplate.tmpl";
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE = "KiePMMLScorecardModelTemplate";

    private KiePMMLScorecardModelFactory() {
    }

    public static KiePMMLScorecardModel getKiePMMLScorecardModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Scorecard model, String packageName, HasClassLoader hasClassLoader) {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        Map<String, String> sourcesMap = KiePMMLScorecardModelFactory.getKiePMMLScorecardModelSourcesMap(dataDictionary, transformationDictionary, model, packageName);
        String fullClassName = packageName + "." + className;
        try {
            Class kiePMMLScorecardModelClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLScorecardModel)kiePMMLScorecardModelClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLScorecardModelSourcesMap(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Scorecard model, String packageName) {
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        String characteristicsClassName = KiePMMLModelUtils.getGeneratedClassName((String)"Characteristics");
        String fullCharacteristicsClassName = String.format("%s.%s", packageName, characteristicsClassName);
        Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm = model.getReasonCodeAlgorithm() != null ? model.getReasonCodeAlgorithm() : Scorecard.ReasonCodeAlgorithm.POINTS_BELOW;
        List derivedFields = ModelUtils.getDerivedFields((TransformationDictionary)transformationDictionary, (LocalTransformations)model.getLocalTransformations());
        Map<String, String> toReturn = KiePMMLCharacteristicsFactory.getKiePMMLCharacteristicsSourcesMap(model.getCharacteristics(), dataDictionary, derivedFields, model.getInitialScore(), reasonCodeAlgorithm, characteristicsClassName, packageName);
        KiePMMLScorecardModelFactory.setConstructor(model, dataDictionary, transformationDictionary, modelTemplate, fullCharacteristicsClassName);
        String fullClassName = packageName + "." + className;
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(Scorecard scorecardModel, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, ClassOrInterfaceDeclaration modelTemplate, String fullCharacteristicsClassName) {
        KiePMMLModelCodegenUtils.init((ClassOrInterfaceDeclaration)modelTemplate, (DataDictionary)dataDictionary, (TransformationDictionary)transformationDictionary, (Model)scorecardModel);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        MethodReferenceExpr characteristicsReference = new MethodReferenceExpr();
        characteristicsReference.setScope((Expression)new NameExpr(fullCharacteristicsClassName));
        characteristicsReference.setIdentifier("evaluateCharacteristics");
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"characteristicsFunction", (Expression)characteristicsReference);
    }
}

