/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.ComplexPartialScore;
import org.dmg.pmml.scorecard.Scorecard;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.ExpressionFunctionUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.kie.pmml.models.scorecard.model.KiePMMLCharacteristics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCharacteristicsFactory {
    static final String KIE_PMML_CHARACTERISTICS_TEMPLATE_JAVA = "KiePMMLCharacteristicsTemplate.tmpl";
    static final String KIE_PMML_CHARACTERISTICS_TEMPLATE = "KiePMMLCharacteristicsTemplate";
    static final String KIE_PMML_CHARACTERISTIC_TEMPLATE_JAVA = "KiePMMLCharacteristicTemplate.tmpl";
    static final String KIE_PMML_CHARACTERISTIC_TEMPLATE = "KiePMMLCharacteristicTemplate";
    static final String EVALUATE_CHARACTERISTICS = "evaluateCharacteristics";
    static final String EVALUATE_CHARACTERISTIC = "evaluateCharacteristic";
    static final String CHARACTERISTIC_FUNCTIONS = "characteristicFunctions";
    static final String EVALUATE_ATTRIBUTE = "evaluateAttribute";
    static final String ATTRIBUTE_FUNCTIONS = "attributeFunctions";
    static final String EVALUATE_COMPLEX_SCORE = "evaluateComplexScore";
    static final String EVALUATE_COMPLEX_SCORE_FUNCTION = "evaluateComplexScoreFunction";
    static final String COMPLEX_SCORE_FUNCTION = "ComplexScoreFunction";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLCharacteristicsFactory.class.getName());

    private KiePMMLCharacteristicsFactory() {
    }

    public static KiePMMLCharacteristics getKiePMMLCharacteristics(Characteristics characteristics, DataDictionary dataDictionary, List<DerivedField> derivedFields, Number initialScore, Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm, String packageName, HasClassLoader hasClassLoader) {
        logger.trace("getKiePMMLCharacteristics {} {}", (Object)packageName, (Object)characteristics);
        String className = KiePMMLModelUtils.getGeneratedClassName((String)"Characteristics");
        String fullClassName = packageName + "." + className;
        Map<String, String> sourcesMap = KiePMMLCharacteristicsFactory.getKiePMMLCharacteristicsSourcesMap(characteristics, dataDictionary, derivedFields, initialScore, reasonCodeAlgorithm, className, packageName);
        try {
            Class kiePMMLCharacteristicsClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLCharacteristics)kiePMMLCharacteristicsClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLCharacteristicsSourcesMap(Characteristics characteristics, DataDictionary dataDictionary, List<DerivedField> derivedFields, Number initialScore, Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm, String containerClassName, String packageName) {
        logger.trace("getKiePMMLCharacteristicsSourcesMap {} {}", (Object)characteristics, (Object)packageName);
        CompilationUnit characteristicsCloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)containerClassName, (String)packageName, (String)KIE_PMML_CHARACTERISTICS_TEMPLATE_JAVA, (String)KIE_PMML_CHARACTERISTICS_TEMPLATE);
        ClassOrInterfaceDeclaration characteristicsTemplate = (ClassOrInterfaceDeclaration)characteristicsCloneCU.getClassByName(containerClassName).orElseThrow(() -> new KiePMMLException("Main class not found: " + containerClassName));
        CompilationUnit characteristicCloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)containerClassName, (String)packageName, (String)KIE_PMML_CHARACTERISTIC_TEMPLATE_JAVA, (String)KIE_PMML_CHARACTERISTIC_TEMPLATE);
        ClassOrInterfaceDeclaration characteristicTemplate = (ClassOrInterfaceDeclaration)characteristicCloneCU.getClassByName(containerClassName).orElseThrow(() -> new KiePMMLException("Main class not found: " + containerClassName));
        AtomicInteger atomicInteger = new AtomicInteger(0);
        NodeList evaluateCharacteristicsReferences = new NodeList();
        for (Characteristic characteristic : characteristics) {
            String characteristicName = containerClassName + "Characteristic_" + atomicInteger.addAndGet(1);
            KiePMMLCharacteristicsFactory.addCharacteristic(characteristicsTemplate, characteristicTemplate, dataDictionary, derivedFields, reasonCodeAlgorithm, characteristic, containerClassName, characteristicName);
            MethodReferenceExpr toAdd = new MethodReferenceExpr();
            toAdd.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(containerClassName));
            String identifier = EVALUATE_CHARACTERISTIC + characteristicName;
            toAdd.setIdentifier(identifier);
            evaluateCharacteristicsReferences.add((Node)toAdd);
        }
        MethodDeclaration characteristicsMethodDeclaration = (MethodDeclaration)characteristicsTemplate.getMethodsByName(EVALUATE_CHARACTERISTICS).get(0);
        BlockStmt body = (BlockStmt)characteristicsMethodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", characteristicsMethodDeclaration)));
        if (initialScore != null) {
            NameExpr initialScoreExpression = new NameExpr(initialScore.toString());
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"initialScore", (com.github.javaparser.ast.expr.Expression)initialScoreExpression);
        }
        MethodCallExpr valuesInit = new MethodCallExpr();
        if (evaluateCharacteristicsReferences.isEmpty()) {
            valuesInit.setScope((com.github.javaparser.ast.expr.Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Collections.class.getName())));
            valuesInit.setName("emptyList");
        } else {
            valuesInit.setScope((com.github.javaparser.ast.expr.Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Arrays.class.getName())));
            valuesInit.setName("asList");
            valuesInit.setArguments(evaluateCharacteristicsReferences);
        }
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)CHARACTERISTIC_FUNCTIONS, (com.github.javaparser.ast.expr.Expression)valuesInit);
        String fullCharacteristicsName = String.format("%s.%s", packageName, containerClassName);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)characteristicsTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", characteristicsTemplate)));
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)containerClassName, (ConstructorDeclaration)constructorDeclaration, (String)containerClassName);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        toReturn.put(fullCharacteristicsName, characteristicsCloneCU.toString());
        return toReturn;
    }

    static void addCharacteristic(ClassOrInterfaceDeclaration characteristicsTemplate, ClassOrInterfaceDeclaration characteristicTemplate, DataDictionary dataDictionary, List<DerivedField> derivedFields, Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm, Characteristic characteristic, String containerClassName, String characteristicName) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        NodeList evaluateAttributesReferences = new NodeList();
        for (Attribute attribute : characteristic.getAttributes()) {
            String attributeName = characteristicName + "_" + atomicInteger.addAndGet(1);
            KiePMMLCharacteristicsFactory.addAttribute(characteristicsTemplate, characteristicTemplate, dataDictionary, derivedFields, attribute, containerClassName, attributeName);
            MethodReferenceExpr toAdd = new MethodReferenceExpr();
            toAdd.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(containerClassName));
            String identifier = EVALUATE_ATTRIBUTE + attributeName;
            toAdd.setIdentifier(identifier);
            evaluateAttributesReferences.add((Node)toAdd);
        }
        MethodDeclaration evaluateCharacteristicMethodDeclaration = KiePMMLCharacteristicsFactory.getEvaluateCharacteristicMethodDeclaration(characteristicTemplate, characteristicName, characteristic.getBaselineScore(), characteristic.getReasonCode(), reasonCodeAlgorithm, (NodeList<com.github.javaparser.ast.expr.Expression>)evaluateAttributesReferences);
        CommonCodegenUtils.addMethodDeclarationToClass((ClassOrInterfaceDeclaration)characteristicsTemplate, (MethodDeclaration)evaluateCharacteristicMethodDeclaration);
    }

    static MethodDeclaration getEvaluateCharacteristicMethodDeclaration(ClassOrInterfaceDeclaration characteristicTemplate, String characteristicName, Object scoreParam, String reasonCode, Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm, NodeList<com.github.javaparser.ast.expr.Expression> evaluateAttributesReferences) {
        MethodDeclaration toReturn = ((MethodDeclaration)characteristicTemplate.getMethodsByName(EVALUATE_CHARACTERISTIC).get(0)).clone();
        toReturn.setName(EVALUATE_CHARACTERISTIC + characteristicName);
        BlockStmt body = (BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", toReturn)));
        if (scoreParam != null) {
            String scoreParamExpr = scoreParam instanceof String ? String.format("\"%s\"", scoreParam) : scoreParam.toString();
            NameExpr scoreExpression = new NameExpr(scoreParamExpr);
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"score", (com.github.javaparser.ast.expr.Expression)scoreExpression);
        }
        if (reasonCode != null) {
            String reasonCodeParamExpr = String.format("\"%s\"", reasonCode);
            NameExpr reasonCodeExpression = new NameExpr(reasonCodeParamExpr);
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"reasonCode", (com.github.javaparser.ast.expr.Expression)reasonCodeExpression);
        }
        if (reasonCodeAlgorithm != null) {
            REASONCODE_ALGORITHM reasCdAl = REASONCODE_ALGORITHM.byName((String)reasonCodeAlgorithm.value());
            String reasonCodeAlgorithmParamExpr = String.format("%s.%s", reasCdAl.getClass().getName(), reasCdAl.name());
            NameExpr reasonCodeAlgorithmExpression = new NameExpr(reasonCodeAlgorithmParamExpr);
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"reasonCodeAlgorithm", (com.github.javaparser.ast.expr.Expression)reasonCodeAlgorithmExpression);
        }
        MethodCallExpr valuesInit = new MethodCallExpr();
        if (evaluateAttributesReferences.isEmpty()) {
            valuesInit.setScope((com.github.javaparser.ast.expr.Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Collections.class.getName())));
            valuesInit.setName("emptyList");
        } else {
            valuesInit.setScope((com.github.javaparser.ast.expr.Expression)new TypeExpr((Type)StaticJavaParser.parseClassOrInterfaceType((String)Arrays.class.getName())));
            valuesInit.setName("asList");
            valuesInit.setArguments(evaluateAttributesReferences);
        }
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)ATTRIBUTE_FUNCTIONS, (com.github.javaparser.ast.expr.Expression)valuesInit);
        return toReturn;
    }

    static void addAttribute(ClassOrInterfaceDeclaration characteristicsTemplate, ClassOrInterfaceDeclaration characteristicTemplate, DataDictionary dataDictionary, List<DerivedField> derivedFields, Attribute attribute, String containerClassName, String attributeName) {
        boolean hasComplexScore;
        KiePMMLCharacteristicsFactory.addPredicate(characteristicsTemplate, characteristicTemplate, dataDictionary, derivedFields, attribute.getPredicate(), containerClassName, attributeName);
        ComplexPartialScore complexPartialScore = attribute.getComplexPartialScore();
        boolean bl = hasComplexScore = complexPartialScore != null;
        if (hasComplexScore) {
            KiePMMLCharacteristicsFactory.addEvaluateComplexScoreMethod(characteristicsTemplate, characteristicTemplate, dataDictionary, complexPartialScore, containerClassName, attributeName);
        }
        MethodDeclaration attributeMethodDeclaration = KiePMMLCharacteristicsFactory.getEvaluateAttributeMethodDeclaration(characteristicTemplate, containerClassName, attributeName, attribute.getPartialScore(), attribute.getReasonCode(), hasComplexScore);
        CommonCodegenUtils.addMethodDeclarationToClass((ClassOrInterfaceDeclaration)characteristicsTemplate, (MethodDeclaration)attributeMethodDeclaration);
    }

    static MethodDeclaration getEvaluateAttributeMethodDeclaration(ClassOrInterfaceDeclaration characteristicTemplate, String containerClassName, String attributeName, Object scoreParam, String reasonCode, boolean hasComplexScore) {
        MethodDeclaration toReturn = ((MethodDeclaration)characteristicTemplate.getMethodsByName(EVALUATE_ATTRIBUTE).get(0)).clone();
        toReturn.setName(EVALUATE_ATTRIBUTE + attributeName);
        BlockStmt body = (BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", toReturn)));
        MethodReferenceExpr predicateReference = new MethodReferenceExpr();
        predicateReference.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(containerClassName));
        String identifier = "evaluatePredicate" + attributeName;
        predicateReference.setIdentifier(identifier);
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"predicateFunction", (com.github.javaparser.ast.expr.Expression)predicateReference);
        if (hasComplexScore) {
            MethodReferenceExpr evaluateComplexScoreReference = new MethodReferenceExpr();
            evaluateComplexScoreReference.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(containerClassName));
            identifier = EVALUATE_COMPLEX_SCORE + attributeName;
            evaluateComplexScoreReference.setIdentifier(identifier);
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)EVALUATE_COMPLEX_SCORE_FUNCTION, (com.github.javaparser.ast.expr.Expression)evaluateComplexScoreReference);
        }
        if (scoreParam != null) {
            String scoreParamExpr = scoreParam instanceof String ? String.format("\"%s\"", scoreParam) : scoreParam.toString();
            NameExpr scoreExpression = new NameExpr(scoreParamExpr);
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"score", (com.github.javaparser.ast.expr.Expression)scoreExpression);
        }
        if (reasonCode != null) {
            String reasonCodeParamExpr = String.format("\"%s\"", reasonCode);
            NameExpr reasonCodeExpression = new NameExpr(reasonCodeParamExpr);
            CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"reasonCode", (com.github.javaparser.ast.expr.Expression)reasonCodeExpression);
        }
        return toReturn;
    }

    static void addEvaluateComplexScoreMethod(ClassOrInterfaceDeclaration characteristicsTemplate, ClassOrInterfaceDeclaration characteristicTemplate, DataDictionary dataDictionary, ComplexPartialScore complexPartialScore, String containerClassName, String attributeName) {
        Expression expression = complexPartialScore.getExpression();
        if (expression == null) {
            throw new IllegalArgumentException("Missing required Expression in ComplexPartialScore " + complexPartialScore);
        }
        String expressionMethodName = COMPLEX_SCORE_FUNCTION + attributeName;
        MethodDeclaration retrieved = ExpressionFunctionUtils.getExpressionMethodDeclarationWithStringObjectMap((Expression)expression, (DataType)DataType.DOUBLE, (String)expressionMethodName);
        retrieved.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC});
        CommonCodegenUtils.addMethodDeclarationToClass((ClassOrInterfaceDeclaration)characteristicsTemplate, (MethodDeclaration)retrieved);
        MethodDeclaration evaluateComplexScoreMethod = ((MethodDeclaration)characteristicTemplate.getMethodsByName(EVALUATE_COMPLEX_SCORE).get(0)).clone();
        evaluateComplexScoreMethod.setName(EVALUATE_COMPLEX_SCORE + attributeName);
        BlockStmt body = (BlockStmt)evaluateComplexScoreMethod.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", evaluateComplexScoreMethod)));
        MethodCallExpr methodReferenceExpr = new MethodCallExpr();
        methodReferenceExpr.setScope((com.github.javaparser.ast.expr.Expression)new NameExpr(containerClassName));
        methodReferenceExpr.setName(expressionMethodName);
        methodReferenceExpr.setArguments(NodeList.nodeList((Node[])new com.github.javaparser.ast.expr.Expression[]{new NameExpr("stringObjectMap")}));
        CommonCodegenUtils.setVariableDeclaratorValue((BlockStmt)body, (String)"toReturn", (com.github.javaparser.ast.expr.Expression)methodReferenceExpr);
        CommonCodegenUtils.addMethodDeclarationToClass((ClassOrInterfaceDeclaration)characteristicsTemplate, (MethodDeclaration)evaluateComplexScoreMethod);
    }

    static void addPredicate(ClassOrInterfaceDeclaration characteristicsTemplate, ClassOrInterfaceDeclaration characteristicTemplate, DataDictionary dataDictionary, List<DerivedField> derivedFields, Predicate predicate, String containerClassName, String attributeName) {
        ArrayList<MethodDeclaration> compoundPredicateMethods = new ArrayList<MethodDeclaration>();
        MethodDeclaration evaluatePredicateMethod = ((MethodDeclaration)characteristicTemplate.getMethodsByName("evaluatePredicate").get(0)).clone();
        evaluatePredicateMethod.setName("evaluatePredicate" + attributeName);
        BlockStmt evaluatePredicateBody = KiePMMLPredicateFactory.getPredicateBody((Predicate)predicate, (DataDictionary)dataDictionary, derivedFields, compoundPredicateMethods, (String)containerClassName, (String)attributeName, (AtomicInteger)new AtomicInteger());
        evaluatePredicateMethod.setBody(evaluatePredicateBody);
        compoundPredicateMethods.add(evaluatePredicateMethod);
        CommonCodegenUtils.addMethodDeclarationsToClass((ClassOrInterfaceDeclaration)characteristicsTemplate, compoundPredicateMethods);
    }
}

