/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.iinterfaces.SerializableFunction;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.models.regression.model.AbstractKiePMMLTable;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;
import org.kie.pmml.models.regression.model.enums.REGRESSION_NORMALIZATION_METHOD;

public final class KiePMMLClassificationTable
extends AbstractKiePMMLTable {
    private static final long serialVersionUID = 458989873257189359L;
    private REGRESSION_NORMALIZATION_METHOD regressionNormalizationMethod;
    private OP_TYPE opType;
    private Map<String, KiePMMLRegressionTable> categoryTableMap = new LinkedHashMap<String, KiePMMLRegressionTable>();
    private SerializableFunction<LinkedHashMap<String, Double>, LinkedHashMap<String, Double>> probabilityMapFunction;
    private boolean isBinary;

    public static Builder builder(String name, List<KiePMMLExtension> extensions) {
        return new Builder(name, extensions);
    }

    @Override
    public Object evaluateRegression(Map<String, Object> input, PMMLContext context) {
        LinkedHashMap<String, Double> resultMap = new LinkedHashMap<String, Double>();
        for (Map.Entry<String, KiePMMLRegressionTable> entry : this.categoryTableMap.entrySet()) {
            resultMap.put(entry.getKey(), (Double)entry.getValue().evaluateRegression(input, context));
        }
        context.setProbabilityResultMap((LinkedHashMap)this.probabilityMapFunction.apply(resultMap));
        Map.Entry predictedEntry = Collections.max(context.getProbabilityResultMap().entrySet(), Map.Entry.comparingByValue());
        return predictedEntry.getKey();
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public REGRESSION_NORMALIZATION_METHOD getRegressionNormalizationMethod() {
        return this.regressionNormalizationMethod;
    }

    public OP_TYPE getOpType() {
        return this.opType;
    }

    public Map<String, KiePMMLRegressionTable> getCategoryTableMap() {
        return this.categoryTableMap;
    }

    private KiePMMLClassificationTable(String name, List<KiePMMLExtension> extensions) {
        super(name, extensions);
    }

    public static LinkedHashMap<String, Double> getProbabilityMap(LinkedHashMap<String, Double> resultMap, DoubleUnaryOperator firstItemOperator, DoubleUnaryOperator secondItemOperator) {
        if (resultMap.size() != 2) {
            throw new KiePMMLException(String.format("Expected two entries, retrieved %d", resultMap.size()));
        }
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        String[] resultMapKeys = resultMap.keySet().toArray(new String[0]);
        double firstItem = firstItemOperator.applyAsDouble(resultMap.get(resultMapKeys[0]));
        double secondItem = secondItemOperator.applyAsDouble(firstItem);
        toReturn.put(resultMapKeys[0], firstItem);
        toReturn.put(resultMapKeys[1], secondItem);
        return toReturn;
    }

    public static LinkedHashMap<String, Double> getSOFTMAXProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        AtomicReference<Double> sumCounter = new AtomicReference<Double>(0.0);
        for (Map.Entry<String, Double> entry : resultMap.entrySet()) {
            double toPut = Math.exp(entry.getValue());
            toReturn.put(entry.getKey(), toPut);
            sumCounter.accumulateAndGet(toPut, Double::sum);
        }
        double sum = sumCounter.get();
        for (Map.Entry entry : toReturn.entrySet()) {
            entry.setValue((Double)entry.getValue() / sum);
        }
        return toReturn;
    }

    public static LinkedHashMap<String, Double> getSIMPLEMAXProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        AtomicReference<Double> sumCounter = new AtomicReference<Double>(0.0);
        for (Double toAdd : resultMap.values()) {
            sumCounter.accumulateAndGet(toAdd, Double::sum);
        }
        double sum = sumCounter.get();
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        for (Map.Entry<String, Double> entry : resultMap.entrySet()) {
            toReturn.put(entry.getKey(), entry.getValue() / sum);
        }
        return toReturn;
    }

    public static LinkedHashMap<String, Double> getNONEProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        String[] resultMapKeys = resultMap.keySet().toArray(new String[0]);
        AtomicReference<Double> sumCounter = new AtomicReference<Double>(0.0);
        for (int i = 0; i < resultMap.size(); ++i) {
            String key = resultMapKeys[i];
            double value = resultMap.get(key);
            if (i < resultMapKeys.length - 1) {
                sumCounter.accumulateAndGet(value, Double::sum);
                toReturn.put(key, value);
                continue;
            }
            toReturn.put(key, 1.0 - sumCounter.get());
        }
        return toReturn;
    }

    public static LinkedHashMap<String, Double> getNONEBinaryProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        String[] resultMapKeys = resultMap.keySet().toArray(new String[0]);
        String key = resultMapKeys[0];
        double value = Math.max(0.0, Math.min(1.0, resultMap.get(key)));
        toReturn.put(key, value);
        toReturn.put(resultMapKeys[1], 1.0 - value);
        return toReturn;
    }

    public static LinkedHashMap<String, Double> getLOGITProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        DoubleUnaryOperator firstItemOperator = aDouble -> 1.0 / (1.0 + Math.exp(0.0 - aDouble));
        DoubleUnaryOperator secondItemOperator = aDouble -> 1.0 - aDouble;
        return KiePMMLClassificationTable.getProbabilityMap(resultMap, firstItemOperator, secondItemOperator);
    }

    public static LinkedHashMap<String, Double> getPROBITProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        DoubleUnaryOperator firstItemOperator = aDouble -> new NormalDistribution().cumulativeProbability(aDouble);
        DoubleUnaryOperator secondItemOperator = aDouble -> 1.0 - aDouble;
        return KiePMMLClassificationTable.getProbabilityMap(resultMap, firstItemOperator, secondItemOperator);
    }

    public static LinkedHashMap<String, Double> getCLOGLOGProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        DoubleUnaryOperator firstItemOperator = aDouble -> 1.0 - Math.exp(0.0 - Math.exp(aDouble));
        DoubleUnaryOperator secondItemOperator = aDouble -> 1.0 - aDouble;
        return KiePMMLClassificationTable.getProbabilityMap(resultMap, firstItemOperator, secondItemOperator);
    }

    public static LinkedHashMap<String, Double> getCAUCHITProbabilityMap(LinkedHashMap<String, Double> resultMap) {
        DoubleUnaryOperator firstItemOperator = aDouble -> 0.5 + 0.3183098861837907 * Math.atan(aDouble);
        DoubleUnaryOperator secondItemOperator = aDouble -> 1.0 - aDouble;
        return KiePMMLClassificationTable.getProbabilityMap(resultMap, firstItemOperator, secondItemOperator);
    }

    public static class Builder
    extends AbstractKiePMMLTable.Builder<KiePMMLClassificationTable> {
        protected Builder(String name, List<KiePMMLExtension> extensions) {
            super("KiePMMLRegressionClassificationTable-", () -> new KiePMMLClassificationTable(name, extensions));
        }

        public Builder withRegressionNormalizationMethod(REGRESSION_NORMALIZATION_METHOD regressionNormalizationMethod) {
            ((KiePMMLClassificationTable)this.toBuild).regressionNormalizationMethod = regressionNormalizationMethod;
            return this;
        }

        public Builder withOpType(OP_TYPE opType) {
            ((KiePMMLClassificationTable)this.toBuild).opType = opType;
            return this;
        }

        public Builder withCategoryTableMap(Map<String, KiePMMLRegressionTable> categoryTableMap) {
            if (categoryTableMap != null) {
                ((KiePMMLClassificationTable)this.toBuild).categoryTableMap.putAll(categoryTableMap);
            }
            return this;
        }

        public Builder withProbabilityMapFunction(SerializableFunction<LinkedHashMap<String, Double>, LinkedHashMap<String, Double>> probabilityMapFunction) {
            ((KiePMMLClassificationTable)this.toBuild).probabilityMapFunction = probabilityMapFunction;
            return this;
        }

        public Builder withIsBinary(Boolean isBinary) {
            if (isBinary != null) {
                ((KiePMMLClassificationTable)this.toBuild).isBinary = isBinary;
            }
            return this;
        }
    }
}

