/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.iinterfaces.SerializableFunction;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.compiler.dto.RegressionCompilationDTO;
import org.kie.pmml.models.regression.model.AbstractKiePMMLTable;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionTableFactory {
    static final String KIE_PMML_REGRESSION_TABLE_TEMPLATE_JAVA = "KiePMMLRegressionTableTemplate.tmpl";
    static final String KIE_PMML_REGRESSION_TABLE_TEMPLATE = "KiePMMLRegressionTableTemplate";
    static final String GETKIEPMML_TABLE = "getKiePMMLTable";
    static final String NUMERIC_FUNCTION_MAP = "numericFunctionMap";
    static final String CATEGORICAL_FUNCTION_MAP = "categoricalFunctionMap";
    static final String PREDICTOR_TERM_FUNCTION_MAP = "predictorTermFunctionMap";
    static final ClassOrInterfaceDeclaration REGRESSION_TABLE_TEMPLATE;
    static final Logger logger;
    static final String KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA = "KiePMMLEvaluateMethodTemplate.tmpl";
    static final String KIE_PMML_EVALUATE_METHOD_TEMPLATE = "KiePMMLEvaluateMethodTemplate";
    static final List<RegressionModel.NormalizationMethod> SUPPORTED_NORMALIZATION_METHODS;
    static final List<RegressionModel.NormalizationMethod> UNSUPPORTED_NORMALIZATION_METHODS;
    private static final String COEFFICIENT = "coefficient";
    private static AtomicInteger classArity;
    private static AtomicInteger predictorsArity;
    private static CompilationUnit templateEvaluate;
    private static CompilationUnit cloneEvaluate;

    private KiePMMLRegressionTableFactory() {
    }

    public static LinkedHashMap<String, KiePMMLRegressionTable> getRegressionTables(RegressionCompilationDTO compilationDTO) {
        logger.trace("getRegressionTables {}", compilationDTO.getRegressionTables());
        LinkedHashMap<String, KiePMMLRegressionTable> toReturn = new LinkedHashMap<String, KiePMMLRegressionTable>();
        for (RegressionTable regressionTable : compilationDTO.getRegressionTables()) {
            KiePMMLRegressionTable kiePMMLRegressionTable = KiePMMLRegressionTableFactory.getRegressionTable(regressionTable, compilationDTO);
            String targetCategory = regressionTable.getTargetCategory() != null ? regressionTable.getTargetCategory().toString() : "";
            toReturn.put(targetCategory, kiePMMLRegressionTable);
        }
        return toReturn;
    }

    public static KiePMMLRegressionTable getRegressionTable(RegressionTable regressionTable, RegressionCompilationDTO compilationDTO) {
        logger.trace("getRegressionTable {}", (Object)regressionTable);
        Map<String, SerializableFunction<Double, Double>> numericPredictorsMap = KiePMMLRegressionTableFactory.getNumericPredictorsMap(regressionTable.getNumericPredictors());
        Map<String, SerializableFunction<String, Double>> categoricalPredictorsMap = KiePMMLRegressionTableFactory.getCategoricalPredictorsMap(regressionTable.getCategoricalPredictors());
        Map<String, SerializableFunction<Map<String, Object>, Double>> predictorTermFunctionMap = KiePMMLRegressionTableFactory.getPredictorTermsMap(regressionTable.getPredictorTerms());
        SerializableFunction<Double, Double> resultUpdater = KiePMMLRegressionTableFactory.getResultUpdaterFunction(compilationDTO.getDefaultNormalizationMethod());
        Double intercept = regressionTable.getIntercept() != null ? Double.valueOf(regressionTable.getIntercept().doubleValue()) : null;
        return (KiePMMLRegressionTable)KiePMMLRegressionTable.builder((String)UUID.randomUUID().toString(), Collections.emptyList()).withNumericFunctionMap(numericPredictorsMap).withCategoricalFunctionMap(categoricalPredictorsMap).withPredictorTermsFunctionMap(predictorTermFunctionMap).withResultUpdater(resultUpdater).withIntercept(intercept).withTargetField(compilationDTO.getTargetFieldName()).withTargetCategory(regressionTable.getTargetCategory()).build();
    }

    public static LinkedHashMap<String, KiePMMLTableSourceCategory> getRegressionTableBuilders(RegressionCompilationDTO compilationDTO) {
        logger.trace("getRegressionTables {}", compilationDTO.getRegressionTables());
        LinkedHashMap<String, KiePMMLTableSourceCategory> toReturn = new LinkedHashMap<String, KiePMMLTableSourceCategory>();
        for (RegressionTable regressionTable : compilationDTO.getRegressionTables()) {
            Map.Entry<String, String> regressionTableEntry = KiePMMLRegressionTableFactory.getRegressionTableBuilder(regressionTable, compilationDTO);
            String targetCategory = regressionTable.getTargetCategory() != null ? regressionTable.getTargetCategory().toString() : "";
            toReturn.put(regressionTableEntry.getKey(), new KiePMMLTableSourceCategory(regressionTableEntry.getValue(), targetCategory));
        }
        return toReturn;
    }

    public static Map.Entry<String, String> getRegressionTableBuilder(RegressionTable regressionTable, RegressionCompilationDTO compilationDTO) {
        logger.trace("getRegressionTableBuilder {}", (Object)regressionTable);
        String className = "KiePMMLRegressionTable" + classArity.addAndGet(1);
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)compilationDTO.getPackageName(), (String)KIE_PMML_REGRESSION_TABLE_TEMPLATE_JAVA, (String)KIE_PMML_REGRESSION_TABLE_TEMPLATE);
        ClassOrInterfaceDeclaration tableTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        MethodDeclaration staticGetterMethod = (MethodDeclaration)tableTemplate.getMethodsByName(GETKIEPMML_TABLE).get(0);
        KiePMMLRegressionTableFactory.setStaticGetter(regressionTable, compilationDTO, staticGetterMethod, className.toLowerCase());
        return new AbstractMap.SimpleEntry<String, String>(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
    }

    static Map<String, SerializableFunction<Double, Double>> getNumericPredictorsMap(List<NumericPredictor> numericPredictors) {
        return numericPredictors.stream().collect(Collectors.toMap(numericPredictor -> numericPredictor.getName().getValue(), KiePMMLRegressionTableFactory::getNumericPredictorEntry));
    }

    static SerializableFunction<Double, Double> getNumericPredictorEntry(NumericPredictor numericPredictor) {
        boolean withExponent;
        boolean bl = withExponent = !Objects.equals(1, numericPredictor.getExponent());
        if (withExponent) {
            return (SerializableFunction & Serializable)input -> KiePMMLRegressionTable.evaluateNumericWithExponent((double)input, (double)numericPredictor.getCoefficient().doubleValue(), (double)numericPredictor.getExponent().doubleValue());
        }
        return (SerializableFunction & Serializable)input -> KiePMMLRegressionTable.evaluateNumericWithoutExponent((double)input, (double)numericPredictor.getCoefficient().doubleValue());
    }

    static Map<String, SerializableFunction<String, Double>> getCategoricalPredictorsMap(List<CategoricalPredictor> categoricalPredictors) {
        Map<String, List<CategoricalPredictor>> groupedCollectors = categoricalPredictors.stream().collect(Collectors.groupingBy(categoricalPredictor -> categoricalPredictor.getField().getValue()));
        return groupedCollectors.entrySet().stream().map(entry -> {
            Map<String, Double> groupedCategoricalPredictorMap = KiePMMLRegressionTableFactory.getGroupedCategoricalPredictorMap((List)entry.getValue());
            SerializableFunction & Serializable function = (SerializableFunction & Serializable)input -> KiePMMLRegressionTable.evaluateCategoricalPredictor((Object)input, (Map)groupedCategoricalPredictorMap);
            return new AbstractMap.SimpleEntry<String, SerializableFunction & Serializable>((String)entry.getKey(), function);
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static Map<String, Double> getGroupedCategoricalPredictorMap(List<CategoricalPredictor> categoricalPredictors) {
        LinkedHashMap<String, Double> toReturn = new LinkedHashMap<String, Double>();
        for (CategoricalPredictor categoricalPredictor : categoricalPredictors) {
            toReturn.put(categoricalPredictor.getValue().toString(), categoricalPredictor.getCoefficient().doubleValue());
        }
        return toReturn;
    }

    static Map<String, SerializableFunction<Map<String, Object>, Double>> getPredictorTermsMap(List<PredictorTerm> predictorTerms) {
        predictorsArity.set(0);
        return predictorTerms.stream().map(predictorTerm -> {
            int arity = predictorsArity.addAndGet(1);
            Object variableName = predictorTerm.getName() != null ? predictorTerm.getName().getValue() : "predictorTermFunction" + arity;
            return new AbstractMap.SimpleEntry<Object, SerializableFunction<Map<String, Object>, Double>>(variableName, KiePMMLRegressionTableFactory.getPredictorTermSerializableFunction(predictorTerm));
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static SerializableFunction<Map<String, Object>, Double> getPredictorTermSerializableFunction(PredictorTerm predictorTerm) {
        return (SerializableFunction & Serializable)resultMap -> {
            AtomicReference<Double> result = new AtomicReference<Double>(1.0);
            List fieldRefs = predictorTerm.getFieldRefs().stream().map(fieldRef -> fieldRef.getField().getValue()).collect(Collectors.toList());
            for (Map.Entry entry : resultMap.entrySet()) {
                if (!fieldRefs.contains(entry.getKey())) continue;
                result.set(result.get() * (Double)entry.getValue());
            }
            return result.get() * predictorTerm.getCoefficient().doubleValue();
        };
    }

    static SerializableFunction<Double, Double> getResultUpdaterFunction(RegressionModel.NormalizationMethod normalizationMethod) {
        if (UNSUPPORTED_NORMALIZATION_METHODS.contains(normalizationMethod)) {
            return null;
        }
        return KiePMMLRegressionTableFactory.getResultUpdaterSupportedFunction(normalizationMethod);
    }

    static SerializableFunction<Double, Double> getResultUpdaterSupportedFunction(RegressionModel.NormalizationMethod normalizationMethod) {
        switch (normalizationMethod) {
            case SOFTMAX: {
                return AbstractKiePMMLTable::updateSOFTMAXResult;
            }
            case LOGIT: {
                return AbstractKiePMMLTable::updateLOGITResult;
            }
            case EXP: {
                return AbstractKiePMMLTable::updateEXPResult;
            }
            case PROBIT: {
                return AbstractKiePMMLTable::updatePROBITResult;
            }
            case CLOGLOG: {
                return AbstractKiePMMLTable::updateCLOGLOGResult;
            }
            case CAUCHIT: {
                return AbstractKiePMMLTable::updateCAUCHITResult;
            }
            case NONE: {
                return AbstractKiePMMLTable::updateNONEResult;
            }
        }
        throw new KiePMMLException("Unexpected NormalizationMethod " + normalizationMethod);
    }

    static void setStaticGetter(RegressionTable regressionTable, RegressionCompilationDTO compilationDTO, MethodDeclaration staticGetterMethod, String variableName) {
        BlockStmt regressionTableBody = (BlockStmt)staticGetterMethod.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", staticGetterMethod)));
        BlockStmt newBody = new BlockStmt();
        String numericFunctionMapName = String.format("%s_%s", NUMERIC_FUNCTION_MAP, variableName);
        Map<String, Expression> numericPredictorsMap = KiePMMLRegressionTableFactory.getNumericPredictorsExpressions(regressionTable.getNumericPredictors());
        CommonCodegenUtils.createPopulatedHashMap((BlockStmt)newBody, (String)numericFunctionMapName, Arrays.asList(String.class.getSimpleName(), "SerializableFunction<Double, Double>"), numericPredictorsMap);
        Map<String, Expression> categoricalPredictorFunctionsMap = KiePMMLRegressionTableFactory.getCategoricalPredictorsExpressions(regressionTable.getCategoricalPredictors(), newBody, variableName);
        String categoricalFunctionMapName = String.format("%s_%s", CATEGORICAL_FUNCTION_MAP, variableName);
        CommonCodegenUtils.createPopulatedHashMap((BlockStmt)newBody, (String)categoricalFunctionMapName, Arrays.asList(String.class.getSimpleName(), "SerializableFunction<String, Double>"), categoricalPredictorFunctionsMap);
        String predictorTermsFunctionMapName = String.format("%s_%s", PREDICTOR_TERM_FUNCTION_MAP, variableName);
        Map<String, Expression> predictorTermsMap = KiePMMLRegressionTableFactory.getPredictorTermFunctions(regressionTable.getPredictorTerms());
        CommonCodegenUtils.createPopulatedHashMap((BlockStmt)newBody, (String)predictorTermsFunctionMapName, Arrays.asList(String.class.getSimpleName(), "SerializableFunction<Map<String, Object>, Double>"), predictorTermsMap);
        VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)regressionTableBody, (String)"toReturn").orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", "toReturn", regressionTableBody)));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", "toReturn", regressionTableBody)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom((String)"builder", (MethodCallExpr)initializer);
        builder.setArgument(0, (Expression)new StringLiteralExpr(variableName));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withNumericFunctionMap", (MethodCallExpr)initializer).setArgument(0, (Expression)new NameExpr(numericFunctionMapName){});
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withCategoricalFunctionMap", (MethodCallExpr)initializer).setArgument(0, (Expression)new NameExpr(categoricalFunctionMapName));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withPredictorTermsFunctionMap", (MethodCallExpr)initializer).setArgument(0, (Expression)new NameExpr(predictorTermsFunctionMapName));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withIntercept", (MethodCallExpr)initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject((Object)regressionTable.getIntercept().doubleValue()));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withTargetField", (MethodCallExpr)initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject((Object)compilationDTO.getTargetFieldName()));
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withTargetCategory", (MethodCallExpr)initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject((Object)regressionTable.getTargetCategory()));
        Expression resultUpdaterExpression = KiePMMLRegressionTableFactory.getResultUpdaterExpression(compilationDTO.getDefaultNormalizationMethod());
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withResultUpdater", (MethodCallExpr)initializer).setArgument(0, resultUpdaterExpression);
        regressionTableBody.getStatements().forEach(arg_0 -> ((BlockStmt)newBody).addStatement(arg_0));
        staticGetterMethod.setBody(newBody);
    }

    static Expression getResultUpdaterExpression(RegressionModel.NormalizationMethod normalizationMethod) {
        if (UNSUPPORTED_NORMALIZATION_METHODS.contains(normalizationMethod)) {
            return new NullLiteralExpr();
        }
        return KiePMMLRegressionTableFactory.getResultUpdaterSupportedExpression(normalizationMethod);
    }

    static MethodReferenceExpr getResultUpdaterSupportedExpression(RegressionModel.NormalizationMethod normalizationMethod) {
        String thisExpressionMethodName = String.format("update%sResult", normalizationMethod.name());
        CastExpr castExpr = new CastExpr();
        String doubleClassName = Double.class.getSimpleName();
        ClassOrInterfaceType consumerType = CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)SerializableFunction.class.getCanonicalName(), Arrays.asList(doubleClassName, doubleClassName));
        castExpr.setType((Type)consumerType);
        castExpr.setExpression(KiePMMLRegressionTable.class.getSimpleName());
        MethodReferenceExpr toReturn = new MethodReferenceExpr();
        toReturn.setScope((Expression)castExpr);
        toReturn.setIdentifier(thisExpressionMethodName);
        return toReturn;
    }

    static Map<String, Expression> getNumericPredictorsExpressions(List<NumericPredictor> numericPredictors) {
        return numericPredictors.stream().collect(Collectors.toMap(numericPredictor -> numericPredictor.getName().getValue(), KiePMMLRegressionTableFactory::getNumericPredictorExpression));
    }

    static CastExpr getNumericPredictorExpression(NumericPredictor numericPredictor) {
        boolean withExponent = !Objects.equals(1, numericPredictor.getExponent());
        String lambdaExpressionMethodName = withExponent ? "evaluateNumericWithExponent" : "evaluateNumericWithoutExponent";
        String parameterName = "input";
        MethodCallExpr lambdaMethodCallExpr = new MethodCallExpr();
        lambdaMethodCallExpr.setName(lambdaExpressionMethodName);
        lambdaMethodCallExpr.setScope((Expression)new NameExpr(KiePMMLRegressionTable.class.getSimpleName()));
        NodeList arguments = new NodeList();
        arguments.add(0, (Node)new NameExpr("input"));
        arguments.add(1, (Node)CommonCodegenUtils.getExpressionForObject((Object)numericPredictor.getCoefficient().doubleValue()));
        if (withExponent) {
            arguments.add(2, (Node)CommonCodegenUtils.getExpressionForObject((Object)numericPredictor.getExponent().doubleValue()));
        }
        lambdaMethodCallExpr.setArguments(arguments);
        ExpressionStmt lambdaExpressionStmt = new ExpressionStmt((Expression)lambdaMethodCallExpr);
        LambdaExpr lambdaExpr = new LambdaExpr();
        Parameter lambdaParameter = new Parameter((Type)new UnknownType(), "input");
        lambdaExpr.setParameters(NodeList.nodeList((Node[])new Parameter[]{lambdaParameter}));
        lambdaExpr.setBody((Statement)lambdaExpressionStmt);
        String doubleClassName = Double.class.getSimpleName();
        ClassOrInterfaceType serializableFunctionType = CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)SerializableFunction.class.getCanonicalName(), Arrays.asList(doubleClassName, doubleClassName));
        CastExpr toReturn = new CastExpr();
        toReturn.setType((Type)serializableFunctionType);
        toReturn.setExpression((Expression)lambdaExpr);
        return toReturn;
    }

    static Map<String, Expression> getCategoricalPredictorsExpressions(List<CategoricalPredictor> categoricalPredictors, BlockStmt body, String variableName) {
        Map<String, List<CategoricalPredictor>> groupedCollectors = categoricalPredictors.stream().collect(Collectors.groupingBy(categoricalPredictor -> categoricalPredictor.getField().getValue()));
        String categoricalPredictorMapNameBase = KiePMMLModelUtils.getSanitizedVariableName((String)String.format("%sMap", variableName));
        AtomicInteger counter = new AtomicInteger();
        return groupedCollectors.entrySet().stream().map(entry -> {
            String categoricalPredictorMapName = String.format("%s_%s", categoricalPredictorMapNameBase, counter.getAndIncrement());
            KiePMMLRegressionTableFactory.populateWithGroupedCategoricalPredictorMap((List)entry.getValue(), body, categoricalPredictorMapName);
            return new AbstractMap.SimpleEntry<String, CastExpr>((String)entry.getKey(), KiePMMLRegressionTableFactory.getCategoricalPredictorExpression(categoricalPredictorMapName));
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static void populateWithGroupedCategoricalPredictorMap(List<CategoricalPredictor> categoricalPredictors, BlockStmt toPopulate, String categoricalPredictorMapName) {
        VariableDeclarator categoricalMapDeclarator = new VariableDeclarator((Type)CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)Map.class.getName(), Arrays.asList(String.class.getSimpleName(), Double.class.getSimpleName())), categoricalPredictorMapName);
        ObjectCreationExpr categoricalMapInitializer = new ObjectCreationExpr();
        categoricalMapInitializer.setType(CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)HashMap.class.getName(), Arrays.asList(String.class.getSimpleName(), Double.class.getSimpleName())));
        categoricalMapDeclarator.setInitializer((Expression)categoricalMapInitializer);
        VariableDeclarationExpr categoricalMapDeclarationExpr = new VariableDeclarationExpr(categoricalMapDeclarator);
        toPopulate.addStatement((Expression)categoricalMapDeclarationExpr);
        LinkedHashMap mapExpressions = new LinkedHashMap();
        categoricalPredictors.forEach(categoricalPredictor -> mapExpressions.put(categoricalPredictor.getValue().toString(), CommonCodegenUtils.getExpressionForObject((Object)categoricalPredictor.getCoefficient().doubleValue())));
        CommonCodegenUtils.addMapPopulationExpressions(mapExpressions, (BlockStmt)toPopulate, (String)categoricalPredictorMapName);
    }

    static CastExpr getCategoricalPredictorExpression(String categoricalPredictorMapName) {
        String lambdaExpressionMethodName = "evaluateCategoricalPredictor";
        String parameterName = "input";
        MethodCallExpr lambdaMethodCallExpr = new MethodCallExpr();
        lambdaMethodCallExpr.setName("evaluateCategoricalPredictor");
        NodeList arguments = new NodeList();
        arguments.add(0, (Node)new NameExpr("input"));
        arguments.add(1, (Node)new NameExpr(categoricalPredictorMapName));
        lambdaMethodCallExpr.setArguments(arguments);
        ExpressionStmt lambdaExpressionStmt = new ExpressionStmt((Expression)lambdaMethodCallExpr);
        LambdaExpr lambdaExpr = new LambdaExpr();
        Parameter lambdaParameter = new Parameter((Type)new UnknownType(), "input");
        lambdaExpr.setParameters(NodeList.nodeList((Node[])new Parameter[]{lambdaParameter}));
        lambdaExpr.setBody((Statement)lambdaExpressionStmt);
        lambdaMethodCallExpr.setScope((Expression)new NameExpr(KiePMMLRegressionTable.class.getSimpleName()));
        ClassOrInterfaceType serializableFunctionType = CommonCodegenUtils.getTypedClassOrInterfaceTypeByTypeNames((String)SerializableFunction.class.getCanonicalName(), Arrays.asList(String.class.getSimpleName(), Double.class.getSimpleName()));
        CastExpr toReturn = new CastExpr();
        toReturn.setType((Type)serializableFunctionType);
        toReturn.setExpression((Expression)lambdaExpr);
        return toReturn;
    }

    static Map<String, Expression> getPredictorTermFunctions(List<PredictorTerm> predictorTerms) {
        predictorsArity.set(0);
        return predictorTerms.stream().map(predictorTerm -> {
            int arity = predictorsArity.addAndGet(1);
            Object variableName = predictorTerm.getName() != null ? predictorTerm.getName().getValue() : "predictorTermFunction" + arity;
            return new AbstractMap.SimpleEntry<Object, LambdaExpr>(variableName, KiePMMLRegressionTableFactory.getPredictorTermFunction(predictorTerm));
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static LambdaExpr getPredictorTermFunction(PredictorTerm predictorTerm) {
        try {
            LambdaExpr toReturn = new LambdaExpr();
            toReturn.setParameters(NodeList.nodeList((Node[])new Parameter[]{new Parameter((Type)new UnknownType(), "resultMap")}));
            BlockStmt body = KiePMMLRegressionTableFactory.getPredictorTermBody(predictorTerm);
            toReturn.setBody((Statement)body);
            return toReturn;
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(String.format("Failed to get PredictorTermFunction for %s", predictorTerm), (Throwable)e);
        }
    }

    static BlockStmt getPredictorTermBody(PredictorTerm predictorTerm) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException("Main class not found"));
            MethodDeclaration methodTemplate = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluatePredictor").get(0);
            BlockStmt body = (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
            VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"fieldRefs").orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", "fieldRefs", body)));
            List nodeList = predictorTerm.getFieldRefs().stream().map(fieldRef -> new StringLiteralExpr(fieldRef.getField().getValue())).collect(Collectors.toList());
            NodeList expressions = NodeList.nodeList(nodeList);
            MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)new NameExpr("Arrays"), "asList", expressions);
            variableDeclarator.setInitializer((Expression)methodCallExpr);
            variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)COEFFICIENT).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", COEFFICIENT, body)));
            variableDeclarator.setInitializer(String.valueOf(predictorTerm.getCoefficient().doubleValue()));
            return (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(String.format("Failed to add PredictorTerm %s", predictorTerm), (Throwable)e);
        }
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName((String)KIE_PMML_REGRESSION_TABLE_TEMPLATE_JAVA);
        REGRESSION_TABLE_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_REGRESSION_TABLE_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLRegressionTableTemplate"));
        logger = LoggerFactory.getLogger((String)KiePMMLRegressionTableFactory.class.getName());
        SUPPORTED_NORMALIZATION_METHODS = Arrays.asList(RegressionModel.NormalizationMethod.SOFTMAX, RegressionModel.NormalizationMethod.LOGIT, RegressionModel.NormalizationMethod.EXP, RegressionModel.NormalizationMethod.PROBIT, RegressionModel.NormalizationMethod.CLOGLOG, RegressionModel.NormalizationMethod.CAUCHIT, RegressionModel.NormalizationMethod.NONE);
        UNSUPPORTED_NORMALIZATION_METHODS = Arrays.asList(RegressionModel.NormalizationMethod.SIMPLEMAX, RegressionModel.NormalizationMethod.LOGLOG);
        classArity = new AtomicInteger(0);
        predictorsArity = new AtomicInteger(0);
    }
}

