/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.compiler.dto.RegressionCompilationDTO;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLClassificationTableFactory;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableFactory;
import org.kie.pmml.models.regression.model.AbstractKiePMMLTable;
import org.kie.pmml.models.regression.model.KiePMMLClassificationTable;
import org.kie.pmml.models.regression.model.KiePMMLRegressionModel;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionModelFactory {
    static final String KIE_PMML_REGRESSION_MODEL_TEMPLATE_JAVA = "KiePMMLRegressionModelTemplate.tmpl";
    static final String KIE_PMML_REGRESSION_MODEL_TEMPLATE = "KiePMMLRegressionModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLRegressionModelFactory.class.getName());

    private KiePMMLRegressionModelFactory() {
    }

    public static KiePMMLRegressionModel getKiePMMLRegressionModelClasses(RegressionCompilationDTO compilationDTO) throws IOException, IllegalAccessException, InstantiationException {
        logger.trace("getKiePMMLRegressionModelClasses {} {}", (Object)compilationDTO.getFields(), (Object)compilationDTO.getModel());
        Map<String, AbstractKiePMMLTable> regressionTablesMap = KiePMMLRegressionModelFactory.getRegressionTables(compilationDTO);
        try {
            AbstractKiePMMLTable nestedTable = regressionTablesMap.size() == 1 ? regressionTablesMap.values().iterator().next() : regressionTablesMap.values().stream().filter(KiePMMLClassificationTable.class::isInstance).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find expected " + KiePMMLClassificationTable.class.getSimpleName()));
            return (KiePMMLRegressionModel)KiePMMLRegressionModel.builder((String)compilationDTO.getFileName(), (String)compilationDTO.getModelName(), (MINING_FUNCTION)compilationDTO.getMINING_FUNCTION()).withAbstractKiePMMLTable(nestedTable).withTargetField(compilationDTO.getTargetFieldName()).withMiningFields(compilationDTO.getKieMiningFields()).withOutputFields(compilationDTO.getKieOutputFields()).withKiePMMLMiningFields(compilationDTO.getKiePMMLMiningFields()).withKiePMMLOutputFields(compilationDTO.getKiePMMLOutputFields()).withKiePMMLTargets(compilationDTO.getKiePMMLTargetFields()).withKiePMMLTransformationDictionary(compilationDTO.getKiePMMLTransformationDictionary()).withKiePMMLLocalTransformations(compilationDTO.getKiePMMLLocalTransformations()).build();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLRegressionModelSourcesMap(RegressionCompilationDTO compilationDTO) throws IOException {
        logger.trace("getKiePMMLRegressionModelSourcesMap {} {} {}", new Object[]{compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getPackageName()});
        String className = compilationDTO.getSimpleClassName();
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)compilationDTO.getPackageName(), (String)KIE_PMML_REGRESSION_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_REGRESSION_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        Map<String, KiePMMLTableSourceCategory> tablesSourceMap = KiePMMLRegressionModelFactory.getRegressionTablesMap(compilationDTO);
        String nestedTable = tablesSourceMap.size() == 1 ? tablesSourceMap.keySet().iterator().next() : tablesSourceMap.keySet().stream().filter(tableName -> tableName.startsWith(compilationDTO.getPackageName() + ".KiePMMLClassificationTable")).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find expected KiePMMLClassificationTable"));
        KiePMMLRegressionModelFactory.setStaticGetter((CompilationDTO<RegressionModel>)compilationDTO, modelTemplate, nestedTable);
        Map<String, String> toReturn = tablesSourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((KiePMMLTableSourceCategory)entry.getValue()).getSource()));
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static Map<String, AbstractKiePMMLTable> getRegressionTables(RegressionCompilationDTO compilationDTO) {
        HashMap<String, AbstractKiePMMLTable> toReturn = new HashMap<String, AbstractKiePMMLTable>();
        if (compilationDTO.isRegression()) {
            List<RegressionTable> regressionTables = Collections.singletonList((RegressionTable)((RegressionModel)compilationDTO.getModel()).getRegressionTables().get(0));
            RegressionCompilationDTO regressionCompilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO<RegressionModel>)compilationDTO, regressionTables, ((RegressionModel)compilationDTO.getModel()).getNormalizationMethod());
            toReturn.putAll(KiePMMLRegressionTableFactory.getRegressionTables(regressionCompilationDTO));
        } else {
            List regressionTables = ((RegressionModel)compilationDTO.getModel()).getRegressionTables();
            RegressionCompilationDTO regressionCompilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO<RegressionModel>)compilationDTO, regressionTables, RegressionModel.NormalizationMethod.NONE);
            KiePMMLClassificationTable kiePMMLClassificationTable = KiePMMLClassificationTableFactory.getClassificationTable(regressionCompilationDTO);
            toReturn.put(kiePMMLClassificationTable.getName(), (AbstractKiePMMLTable)kiePMMLClassificationTable);
        }
        return toReturn;
    }

    static Map<String, KiePMMLTableSourceCategory> getRegressionTablesMap(RegressionCompilationDTO compilationDTO) {
        Map<String, KiePMMLTableSourceCategory> toReturn;
        if (compilationDTO.isRegression()) {
            List<RegressionTable> regressionTables = Collections.singletonList((RegressionTable)((RegressionModel)compilationDTO.getModel()).getRegressionTables().get(0));
            RegressionCompilationDTO regressionCompilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO<RegressionModel>)compilationDTO, regressionTables, ((RegressionModel)compilationDTO.getModel()).getNormalizationMethod());
            toReturn = KiePMMLRegressionTableFactory.getRegressionTableBuilders(regressionCompilationDTO);
        } else {
            List regressionTables = ((RegressionModel)compilationDTO.getModel()).getRegressionTables();
            RegressionCompilationDTO regressionCompilationDTO = RegressionCompilationDTO.fromCompilationDTORegressionTablesAndNormalizationMethod((CompilationDTO<RegressionModel>)compilationDTO, regressionTables, RegressionModel.NormalizationMethod.NONE);
            toReturn = KiePMMLClassificationTableFactory.getClassificationTableBuilders(regressionCompilationDTO);
        }
        return toReturn;
    }

    static void setStaticGetter(CompilationDTO<RegressionModel> compilationDTO, ClassOrInterfaceDeclaration modelTemplate, String nestedTable) {
        KiePMMLModelFactoryUtils.initStaticGetter(compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        BlockStmt body = CommonCodegenUtils.getMethodDeclarationBlockStmt((ClassOrInterfaceDeclaration)modelTemplate, (String)"getModel");
        VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"toReturn").orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", "toReturn", body)));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", "toReturn", body)))).asMethodCallExpr();
        MethodCallExpr methodCallExpr = new MethodCallExpr();
        methodCallExpr.setScope((Expression)new NameExpr(nestedTable));
        methodCallExpr.setName("getKiePMMLTable");
        CommonCodegenUtils.getChainedMethodCallExprFrom((String)"withAbstractKiePMMLTable", (MethodCallExpr)initializer).setArgument(0, (Expression)methodCallExpr);
    }
}

