/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.RESULT_FEATURE;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionTableRegressionFactory {
    public static final String KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE_JAVA = "KiePMMLRegressionTableRegressionTemplate.tmpl";
    public static final String KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE = "KiePMMLRegressionTableRegressionTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLRegressionTableRegressionFactory.class.getName());
    static final String MAIN_CLASS_NOT_FOUND = "Main class not found";
    static final String KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA = "KiePMMLEvaluateMethodTemplate.tmpl";
    static final String KIE_PMML_EVALUATE_METHOD_TEMPLATE = "KiePMMLEvaluateMethodTemplate";
    private static final String KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE_JAVA = "KiePMMLUpdateResultMethodTemplate.tmpl";
    private static final String KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE = "KiePMMLUpdateResultMethodTemplate";
    private static final String COEFFICIENT = "coefficient";
    private static final String EXPONENT = "exponent";
    private static AtomicInteger classArity = new AtomicInteger(0);
    private static AtomicInteger predictorsArity = new AtomicInteger(0);
    private static CompilationUnit templateEvaluate;
    private static CompilationUnit cloneEvaluate;

    private KiePMMLRegressionTableRegressionFactory() {
    }

    public static LinkedHashMap<String, KiePMMLTableSourceCategory> getRegressionTables(List<RegressionTable> regressionTables, RegressionModel.NormalizationMethod normalizationMethod, List<KiePMMLOutputField> outputFields, String targetField, String packageName) {
        logger.trace("getRegressionTables {}", regressionTables);
        LinkedHashMap<String, KiePMMLTableSourceCategory> toReturn = new LinkedHashMap<String, KiePMMLTableSourceCategory>();
        for (RegressionTable regressionTable : regressionTables) {
            Map.Entry<String, String> regressionTableEntry = KiePMMLRegressionTableRegressionFactory.getRegressionTable(regressionTable, normalizationMethod, outputFields, targetField, packageName);
            String targetCategory = regressionTable.getTargetCategory() != null ? regressionTable.getTargetCategory().toString() : "";
            toReturn.put(regressionTableEntry.getKey(), new KiePMMLTableSourceCategory(regressionTableEntry.getValue(), targetCategory));
        }
        return toReturn;
    }

    public static Map.Entry<String, String> getRegressionTable(RegressionTable regressionTable, RegressionModel.NormalizationMethod normalizationMethod, List<KiePMMLOutputField> outputFields, String targetField, String packageName) {
        logger.trace("getRegressionTable {}", (Object)regressionTable);
        String className = "KiePMMLRegressionTableRegression" + classArity.addAndGet(1);
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE_JAVA, (String)KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE);
        ClassOrInterfaceDeclaration tableTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)tableTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", tableTemplate.getName())));
        KiePMMLRegressionTableRegressionFactory.setConstructor(regressionTable, constructorDeclaration, tableTemplate.getName(), targetField);
        Map<String, MethodDeclaration> numericPredictorsMap = KiePMMLRegressionTableRegressionFactory.addNumericPredictors(regressionTable.getNumericPredictors(), tableTemplate);
        Map<String, MethodDeclaration> categoricalPredictorsMap = KiePMMLRegressionTableRegressionFactory.addCategoricalPredictors(regressionTable.getCategoricalPredictors(), tableTemplate);
        Map<String, MethodDeclaration> predictorTermsMap = KiePMMLRegressionTableRegressionFactory.addPredictorTerms(regressionTable.getPredictorTerms(), tableTemplate);
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.addMapPopulation(numericPredictorsMap, (BlockStmt)body, (String)"numericFunctionMap");
        CommonCodegenUtils.addMapPopulation(categoricalPredictorsMap, (BlockStmt)body, (String)"categoricalFunctionMap");
        CommonCodegenUtils.addMapPopulation(predictorTermsMap, (BlockStmt)body, (String)"predictorTermsFunctionMap");
        KiePMMLRegressionTableRegressionFactory.populateGetTargetCategory(tableTemplate, regressionTable.getTargetCategory());
        KiePMMLRegressionTableRegressionFactory.populateUpdateResult(tableTemplate, normalizationMethod);
        KiePMMLRegressionTableRegressionFactory.populateOutputFieldsMap(tableTemplate, outputFields);
        return new AbstractMap.SimpleEntry<String, String>(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
    }

    static void setConstructor(RegressionTable regressionTable, ConstructorDeclaration constructorDeclaration, SimpleName tableName, String targetField) {
        constructorDeclaration.setName(tableName);
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"intercept", (Expression)new DoubleLiteralExpr(String.valueOf(regressionTable.getIntercept().doubleValue())));
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"targetField", (Expression)new StringLiteralExpr(targetField));
    }

    static void populateOutputFieldsMapWithResult(BlockStmt body, List<KiePMMLOutputField> outputFields) {
        outputFields.stream().filter(outputField -> RESULT_FEATURE.PREDICTED_VALUE.equals((Object)outputField.getResultFeature())).forEach(outputField -> {
            StringLiteralExpr key = new StringLiteralExpr(outputField.getName());
            NameExpr value = new NameExpr("result");
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{key, value});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("outputFieldsMap"), "put", expressions));
        });
    }

    static Map<String, MethodDeclaration> addNumericPredictors(List<NumericPredictor> numericPredictors, ClassOrInterfaceDeclaration tableTemplate) {
        predictorsArity.set(0);
        return numericPredictors.stream().map(numericPredictor -> new AbstractMap.SimpleEntry<String, MethodDeclaration>(numericPredictor.getName().getValue(), KiePMMLRegressionTableRegressionFactory.addNumericPredictor(numericPredictor, tableTemplate, predictorsArity.addAndGet(1)))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static MethodDeclaration addNumericPredictor(NumericPredictor numericPredictor, ClassOrInterfaceDeclaration tableTemplate, int predictorArity) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration methodTemplate = Objects.equals(1, numericPredictor.getExponent()) ? KiePMMLRegressionTableRegressionFactory.getNumericPredictorWithoutExponentTemplate(numericPredictor, evaluateTemplateClass) : KiePMMLRegressionTableRegressionFactory.getNumericPredictorWithExponentTemplate(numericPredictor, evaluateTemplateClass);
            return CommonCodegenUtils.addMethod((MethodDeclaration)methodTemplate, (ClassOrInterfaceDeclaration)tableTemplate, (String)("evaluateNumericPredictor" + predictorArity));
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(String.format("Failed to add NumericPredictor %s", numericPredictor.getName()), (Throwable)e);
        }
    }

    static MethodDeclaration getNumericPredictorWithExponentTemplate(NumericPredictor numericPredictor, ClassOrInterfaceDeclaration evaluateTemplateClass) {
        MethodDeclaration toReturn = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluateNumericWithExponent").get(0);
        BlockStmt body = (BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", toReturn.getName())));
        VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)COEFFICIENT).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", COEFFICIENT, body)));
        variableDeclarator.setInitializer(String.valueOf(numericPredictor.getCoefficient().doubleValue()));
        variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)EXPONENT).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", EXPONENT, body)));
        variableDeclarator.setInitializer(String.valueOf(numericPredictor.getExponent().doubleValue()));
        return toReturn;
    }

    static MethodDeclaration getNumericPredictorWithoutExponentTemplate(NumericPredictor numericPredictor, ClassOrInterfaceDeclaration evaluateTemplateClass) {
        MethodDeclaration toReturn = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluateNumericWithoutExponent").get(0);
        BlockStmt body = (BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", toReturn.getName())));
        VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)COEFFICIENT).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", COEFFICIENT, body)));
        variableDeclarator.setInitializer(String.valueOf(numericPredictor.getCoefficient().doubleValue()));
        return toReturn;
    }

    static Map<String, MethodDeclaration> addCategoricalPredictors(List<CategoricalPredictor> categoricalPredictors, ClassOrInterfaceDeclaration tableTemplate) {
        predictorsArity.set(0);
        Map<String, List<CategoricalPredictor>> groupedCollectors = categoricalPredictors.stream().collect(Collectors.groupingBy(categoricalPredictor -> categoricalPredictor.getField().getValue()));
        return groupedCollectors.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), KiePMMLRegressionTableRegressionFactory.addGroupedCategoricalPredictor((List)entry.getValue(), tableTemplate, predictorsArity.addAndGet(1)))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static MethodDeclaration addGroupedCategoricalPredictor(List<CategoricalPredictor> categoricalPredictors, ClassOrInterfaceDeclaration tableTemplate, int predictorArity) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration methodTemplate = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluateCategorical").get(0);
            BlockStmt body = (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
            IfStmt ifStmt = new IfStmt();
            for (int i = 0; i < categoricalPredictors.size(); ++i) {
                CategoricalPredictor categoricalPredictor = categoricalPredictors.get(i);
                Object lhe = categoricalPredictor.getValue() instanceof String ? new StringLiteralExpr((String)categoricalPredictor.getValue()) : new NameExpr(categoricalPredictor.getValue().toString());
                NodeList expressions = NodeList.nodeList((Node[])new Expression[]{lhe, new NameExpr("input")});
                MethodCallExpr conditionExpr = new MethodCallExpr((Expression)new NameExpr("Objects"), "equals", expressions);
                if (i == 0) {
                    ifStmt.setCondition((Expression)conditionExpr);
                    ifStmt.setThenStmt((Statement)new ReturnStmt((Expression)new DoubleLiteralExpr(String.valueOf(categoricalPredictor.getCoefficient()))));
                    body.addStatement((Statement)ifStmt);
                    continue;
                }
                IfStmt elseIf = new IfStmt();
                elseIf.setCondition((Expression)conditionExpr);
                elseIf.setThenStmt((Statement)new ReturnStmt((Expression)new DoubleLiteralExpr(String.valueOf(categoricalPredictor.getCoefficient()))));
                ifStmt.setElseStmt((Statement)elseIf);
                ifStmt = elseIf;
            }
            ifStmt.setElseStmt((Statement)new ReturnStmt((Expression)new DoubleLiteralExpr("0.0")));
            return CommonCodegenUtils.addMethod((MethodDeclaration)methodTemplate, (ClassOrInterfaceDeclaration)tableTemplate, (String)("evaluateCategoricalPredictor" + predictorArity));
        }
        catch (Exception e) {
            throw new KiePMMLInternalException("Failed to add CategoricalPredictors", (Throwable)e);
        }
    }

    static Map<String, MethodDeclaration> addPredictorTerms(List<PredictorTerm> predictorTerms, ClassOrInterfaceDeclaration tableTemplate) {
        predictorsArity.set(0);
        return predictorTerms.stream().map(predictorTerm -> {
            int arity = predictorsArity.addAndGet(1);
            return new AbstractMap.SimpleEntry<String, MethodDeclaration>(predictorTerm.getName() != null ? predictorTerm.getName().getValue() : "predictorTerm" + arity, KiePMMLRegressionTableRegressionFactory.addPredictorTerm(predictorTerm, tableTemplate, arity));
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    static MethodDeclaration addPredictorTerm(PredictorTerm predictorTerm, ClassOrInterfaceDeclaration tableTemplate, int predictorArity) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration methodTemplate = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluatePredictor").get(0);
            BlockStmt body = (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
            VariableDeclarator variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)"fieldRefs").orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", "fieldRefs", body)));
            List nodeList = predictorTerm.getFieldRefs().stream().map(fieldRef -> new StringLiteralExpr(fieldRef.getField().getValue())).collect(Collectors.toList());
            NodeList expressions = NodeList.nodeList(nodeList);
            MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)new NameExpr("Arrays"), "asList", expressions);
            variableDeclarator.setInitializer((Expression)methodCallExpr);
            variableDeclarator = (VariableDeclarator)CommonCodegenUtils.getVariableDeclarator((BlockStmt)body, (String)COEFFICIENT).orElseThrow(() -> new KiePMMLInternalException(String.format("Missing expected variable '%s' in body %s", COEFFICIENT, body)));
            variableDeclarator.setInitializer(String.valueOf(predictorTerm.getCoefficient().doubleValue()));
            return CommonCodegenUtils.addMethod((MethodDeclaration)methodTemplate, (ClassOrInterfaceDeclaration)tableTemplate, (String)("evaluatePredictorTerm" + predictorArity));
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(String.format("Failed to add PredictorTerm %s", predictorTerm), (Throwable)e);
        }
    }

    static void populateGetTargetCategory(ClassOrInterfaceDeclaration tableTemplate, Object targetCategory) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)tableTemplate.getMethodsByName("getTargetCategory").get(0);
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodDeclaration.getName())));
        ReturnStmt returnStmt = new ReturnStmt();
        if (targetCategory == null) {
            returnStmt.setExpression((Expression)new NameExpr("null"));
        } else if (targetCategory instanceof String) {
            returnStmt.setExpression((Expression)new StringLiteralExpr((String)targetCategory));
        } else {
            returnStmt.setExpression((Expression)new NameExpr(targetCategory.toString()));
        }
        body.addStatement((Statement)returnStmt);
    }

    static void populateUpdateResult(ClassOrInterfaceDeclaration tableTemplate, RegressionModel.NormalizationMethod normalizationMethod) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            String methodName = String.format("update%sResult", normalizationMethod.name());
            MethodDeclaration methodDeclaration = (MethodDeclaration)evaluateTemplateClass.getMethodsByName(methodName).get(0);
            BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodDeclaration.getName())));
            MethodDeclaration targetMethod = (MethodDeclaration)tableTemplate.getMethodsByName("updateResult").get(0);
            targetMethod.setBody(body);
        }
        catch (Exception e) {
            throw new KiePMMLInternalException("Failed to populate UpdateResult", (Throwable)e);
        }
    }

    static void populateOutputFieldsMap(ClassOrInterfaceDeclaration tableTemplate, List<KiePMMLOutputField> outputFields) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)tableTemplate.getMethodsByName("populateOutputFieldsMapWithResult").get(0);
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", "populateOutputFieldsMapWithResult")));
        KiePMMLRegressionTableRegressionFactory.populateOutputFieldsMapWithResult(body, outputFields);
    }
}

