/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionTableRegressionFactory {
    public static final String KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE_JAVA = "KiePMMLRegressionTableRegressionTemplate.tmpl";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLRegressionTableRegressionFactory.class.getName());
    private static final String MAIN_CLASS_NOT_FOUND = "Main class not found";
    private static final String KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA = "KiePMMLEvaluateMethodTemplate.tmpl";
    private static final String KIE_PMML_EVALUATE_METHOD_TEMPLATE = "KiePMMLEvaluateMethodTemplate";
    private static final String KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE_JAVA = "KiePMMLUpdateResultMethodTemplate.tmpl";
    private static final String KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE = "KiePMMLUpdateResultMethodTemplate";
    private static final String KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE = "KiePMMLRegressionTableRegressionTemplate";
    private static final String COEFFICIENT = "coefficient";
    private static final String EXPONENT = "exponent";
    private static AtomicInteger classArity = new AtomicInteger(0);
    private static AtomicInteger predictorsArity = new AtomicInteger(0);
    private static CompilationUnit templateEvaluate;
    private static CompilationUnit cloneEvaluate;

    private KiePMMLRegressionTableRegressionFactory() {
    }

    public static Map<String, KiePMMLTableSourceCategory> getRegressionTables(List<RegressionTable> regressionTables, RegressionModel.NormalizationMethod normalizationMethod, String targetField, String packageName) throws IOException {
        logger.trace("getRegressionTables {}", regressionTables);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName((String)KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE_JAVA);
        HashMap<String, KiePMMLTableSourceCategory> toReturn = new HashMap<String, KiePMMLTableSourceCategory>();
        for (RegressionTable regressionTable : regressionTables) {
            Map.Entry<String, String> regressionTableEntry = KiePMMLRegressionTableRegressionFactory.getRegressionTable(templateCU, regressionTable, normalizationMethod, targetField, packageName);
            String targetCategory = regressionTable.getTargetCategory() != null ? regressionTable.getTargetCategory().toString() : "";
            toReturn.put(regressionTableEntry.getKey(), new KiePMMLTableSourceCategory(regressionTableEntry.getValue(), targetCategory));
        }
        return toReturn;
    }

    public static Map.Entry<String, String> getRegressionTable(CompilationUnit templateCU, RegressionTable regressionTable, RegressionModel.NormalizationMethod normalizationMethod, String targetField, String packageName) {
        logger.trace("getRegressionTable {}", (Object)regressionTable);
        CompilationUnit cloneCU = templateCU.clone();
        cloneCU.setPackageDeclaration(packageName);
        ClassOrInterfaceDeclaration tableTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_REGRESSION_TABLE_REGRESSION_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
        String className = "KiePMMLRegressionTableRegression" + classArity.addAndGet(1);
        tableTemplate.setName(className);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)tableTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", tableTemplate.getName())));
        KiePMMLRegressionTableRegressionFactory.setConstructor(regressionTable, constructorDeclaration, tableTemplate.getName(), targetField);
        Map<String, MethodDeclaration> numericPredictorsMap = KiePMMLRegressionTableRegressionFactory.addNumericPredictors(regressionTable.getNumericPredictors(), tableTemplate);
        Map<String, MethodDeclaration> categoricalPredictorsMap = KiePMMLRegressionTableRegressionFactory.addCategoricalPredictors(regressionTable.getCategoricalPredictors(), tableTemplate);
        Map<String, MethodDeclaration> predictorTermsMap = KiePMMLRegressionTableRegressionFactory.addPredictorTerms(regressionTable.getPredictorTerms(), tableTemplate);
        BlockStmt body = constructorDeclaration.getBody();
        CommonCodegenUtils.addMapPopulation(numericPredictorsMap, (BlockStmt)body, (String)"numericFunctionMap");
        CommonCodegenUtils.addMapPopulation(categoricalPredictorsMap, (BlockStmt)body, (String)"categoricalFunctionMap");
        CommonCodegenUtils.addMapPopulation(predictorTermsMap, (BlockStmt)body, (String)"predictorTermsFunctionMap");
        KiePMMLRegressionTableRegressionFactory.populateGetTargetCategory(tableTemplate, regressionTable.getTargetCategory());
        KiePMMLRegressionTableRegressionFactory.populateUpdateResult(tableTemplate, normalizationMethod);
        return new AbstractMap.SimpleEntry<String, String>(className, cloneCU.toString());
    }

    private static void setConstructor(RegressionTable regressionTable, ConstructorDeclaration constructorDeclaration, SimpleName tableName, String targetField) {
        constructorDeclaration.setName(tableName);
        BlockStmt body = constructorDeclaration.getBody();
        List assignExprs = body.findAll(AssignExpr.class);
        assignExprs.forEach(assignExpr -> {
            if (assignExpr.getTarget().asNameExpr().getNameAsString().equals("intercept")) {
                assignExpr.setValue((Expression)new DoubleLiteralExpr(String.valueOf(regressionTable.getIntercept().doubleValue())));
            } else if (assignExpr.getTarget().asNameExpr().getNameAsString().equals("targetField")) {
                assignExpr.setValue((Expression)new StringLiteralExpr(targetField));
            }
        });
    }

    private static Map<String, MethodDeclaration> addNumericPredictors(List<NumericPredictor> numericPredictors, ClassOrInterfaceDeclaration tableTemplate) {
        predictorsArity.set(0);
        return numericPredictors.stream().map(numericPredictor -> new AbstractMap.SimpleEntry<String, MethodDeclaration>(numericPredictor.getName().getValue(), KiePMMLRegressionTableRegressionFactory.addNumericPredictor(numericPredictor, tableTemplate, predictorsArity.addAndGet(1)))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private static MethodDeclaration addNumericPredictor(NumericPredictor numericPredictor, ClassOrInterfaceDeclaration tableTemplate, int predictorArity) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration methodTemplate = Objects.equals(1, numericPredictor.getExponent()) ? KiePMMLRegressionTableRegressionFactory.getNumericPredictorWithoutExponentTemplate(numericPredictor, evaluateTemplateClass) : KiePMMLRegressionTableRegressionFactory.getNumericPredictorWithExponentTemplate(numericPredictor, evaluateTemplateClass);
            return KiePMMLRegressionTableRegressionFactory.addMethod(methodTemplate, tableTemplate, "evaluateNumericPredictor" + predictorArity);
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(String.format("Failed to add NumericPredictor %s", numericPredictor.getName()), (Throwable)e);
        }
    }

    private static MethodDeclaration getNumericPredictorWithExponentTemplate(NumericPredictor numericPredictor, ClassOrInterfaceDeclaration evaluateTemplateClass) {
        MethodDeclaration toReturn = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluateNumericWithExponent").get(0);
        BlockStmt body = (BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", toReturn.getName())));
        List variableDeclarators = body.findAll(VariableDeclarator.class);
        variableDeclarators.forEach(variableDeclarator -> {
            String initializer = null;
            if (variableDeclarator.getName().asString().equals(COEFFICIENT)) {
                initializer = String.valueOf(numericPredictor.getCoefficient().doubleValue());
            } else if (variableDeclarator.getName().asString().equals(EXPONENT)) {
                initializer = String.valueOf(numericPredictor.getExponent().doubleValue());
            }
            if (initializer != null) {
                variableDeclarator.setInitializer(initializer);
            }
        });
        return toReturn;
    }

    private static MethodDeclaration getNumericPredictorWithoutExponentTemplate(NumericPredictor numericPredictor, ClassOrInterfaceDeclaration evaluateTemplateClass) {
        MethodDeclaration toReturn = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluateNumericWithoutExponent").get(0);
        BlockStmt body = (BlockStmt)toReturn.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", toReturn.getName())));
        List variableDeclarators = body.findAll(VariableDeclarator.class);
        variableDeclarators.stream().filter(variableDeclarator -> variableDeclarator.getName().asString().equals(COEFFICIENT)).forEach(variableDeclarator -> variableDeclarator.setInitializer(String.valueOf(numericPredictor.getCoefficient().doubleValue())));
        return toReturn;
    }

    private static Map<String, MethodDeclaration> addCategoricalPredictors(List<CategoricalPredictor> categoricalPredictors, ClassOrInterfaceDeclaration tableTemplate) {
        predictorsArity.set(0);
        Map<String, List<CategoricalPredictor>> groupedCollectors = categoricalPredictors.stream().collect(Collectors.groupingBy(categoricalPredictor -> categoricalPredictor.getField().getValue()));
        return groupedCollectors.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), KiePMMLRegressionTableRegressionFactory.addGroupedCategoricalPredictor((List)entry.getValue(), tableTemplate, predictorsArity.addAndGet(1)))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private static MethodDeclaration addGroupedCategoricalPredictor(List<CategoricalPredictor> categoricalPredictors, ClassOrInterfaceDeclaration tableTemplate, int predictorArity) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration methodTemplate = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluateCategorical").get(0);
            BlockStmt body = (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
            IfStmt ifStmt = new IfStmt();
            for (int i = 0; i < categoricalPredictors.size(); ++i) {
                CategoricalPredictor categoricalPredictor = categoricalPredictors.get(i);
                Object lhe = categoricalPredictor.getValue() instanceof String ? new StringLiteralExpr((String)categoricalPredictor.getValue()) : new NameExpr(categoricalPredictor.getValue().toString());
                NodeList expressions = NodeList.nodeList((Node[])new Expression[]{lhe, new NameExpr("input")});
                MethodCallExpr conditionExpr = new MethodCallExpr((Expression)new NameExpr("Objects"), "equals", expressions);
                if (i == 0) {
                    ifStmt.setCondition((Expression)conditionExpr);
                    ifStmt.setThenStmt((Statement)new ReturnStmt((Expression)new DoubleLiteralExpr(String.valueOf(categoricalPredictor.getCoefficient()))));
                    body.addStatement((Statement)ifStmt);
                    continue;
                }
                IfStmt elseIf = new IfStmt();
                elseIf.setCondition((Expression)conditionExpr);
                elseIf.setThenStmt((Statement)new ReturnStmt((Expression)new DoubleLiteralExpr(String.valueOf(categoricalPredictor.getCoefficient()))));
                ifStmt.setElseStmt((Statement)elseIf);
                ifStmt = elseIf;
            }
            ifStmt.setElseStmt((Statement)new ReturnStmt((Expression)new DoubleLiteralExpr("0.0")));
            return KiePMMLRegressionTableRegressionFactory.addMethod(methodTemplate, tableTemplate, "evaluateCategoricalPredictor" + predictorArity);
        }
        catch (Exception e) {
            throw new KiePMMLInternalException("Failed to add CategoricalPredictors", (Throwable)e);
        }
    }

    private static Map<String, MethodDeclaration> addPredictorTerms(List<PredictorTerm> predictorTerms, ClassOrInterfaceDeclaration tableTemplate) {
        predictorsArity.set(0);
        return predictorTerms.stream().map(predictorTerm -> {
            int arity = predictorsArity.addAndGet(1);
            return new AbstractMap.SimpleEntry<String, MethodDeclaration>(predictorTerm.getName() != null ? predictorTerm.getName().getValue() : "predictorTerm" + arity, KiePMMLRegressionTableRegressionFactory.addPredictorTerm(predictorTerm, tableTemplate, arity));
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private static MethodDeclaration addPredictorTerm(PredictorTerm predictorTerm, ClassOrInterfaceDeclaration tableTemplate, int predictorArity) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_EVALUATE_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_EVALUATE_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration methodTemplate = (MethodDeclaration)evaluateTemplateClass.getMethodsByName("evaluatePredictor").get(0);
            BlockStmt body = (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
            List variableDeclarators = body.findAll(VariableDeclarator.class);
            variableDeclarators.forEach(variableDeclarator -> {
                if (variableDeclarator.getName().asString().equals("fieldRefs")) {
                    List nodeList = predictorTerm.getFieldRefs().stream().map(fieldRef -> new StringLiteralExpr(fieldRef.getField().getValue())).collect(Collectors.toList());
                    NodeList expressions = NodeList.nodeList(nodeList);
                    MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)new NameExpr("Arrays"), "asList", expressions);
                    variableDeclarator.setInitializer((Expression)methodCallExpr);
                } else if (variableDeclarator.getName().asString().equals(COEFFICIENT)) {
                    variableDeclarator.setInitializer(String.valueOf(predictorTerm.getCoefficient().doubleValue()));
                }
            });
            return KiePMMLRegressionTableRegressionFactory.addMethod(methodTemplate, tableTemplate, "evaluatePredictorTerm" + predictorArity);
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(String.format("Failed to add PredictorTerm %s", predictorTerm), (Throwable)e);
        }
    }

    protected static MethodDeclaration addMethod(MethodDeclaration methodTemplate, ClassOrInterfaceDeclaration tableTemplate, String evaluateMethodName) {
        BlockStmt body = (BlockStmt)methodTemplate.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodTemplate.getName())));
        MethodDeclaration toReturn = tableTemplate.addMethod(evaluateMethodName, new Modifier.Keyword[0]).setBody(body);
        toReturn.setModifiers(methodTemplate.getModifiers());
        methodTemplate.getParameters().forEach(arg_0 -> ((MethodDeclaration)toReturn).addParameter(arg_0));
        toReturn.setType(methodTemplate.getType());
        return toReturn;
    }

    protected static void populateGetTargetCategory(ClassOrInterfaceDeclaration tableTemplate, Object targetCategory) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)tableTemplate.getMethodsByName("getTargetCategory").get(0);
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodDeclaration.getName())));
        ReturnStmt returnStmt = new ReturnStmt();
        if (targetCategory == null) {
            returnStmt.setExpression((Expression)new NameExpr("null"));
        } else if (targetCategory instanceof String) {
            returnStmt.setExpression((Expression)new StringLiteralExpr((String)targetCategory));
        } else {
            returnStmt.setExpression((Expression)new NameExpr(targetCategory.toString()));
        }
        body.addStatement((Statement)returnStmt);
    }

    protected static void populateUpdateResult(ClassOrInterfaceDeclaration tableTemplate, RegressionModel.NormalizationMethod normalizationMethod) {
        try {
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_UPDATE_RESULT_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            String methodName = String.format("update%sResult", normalizationMethod.name());
            MethodDeclaration methodDeclaration = (MethodDeclaration)evaluateTemplateClass.getMethodsByName(methodName).get(0);
            BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodDeclaration.getName())));
            MethodDeclaration targetMethod = (MethodDeclaration)tableTemplate.getMethodsByName("updateResult").get(0);
            targetMethod.setBody(body);
        }
        catch (Exception e) {
            throw new KiePMMLInternalException("Failed to populate UpdateResult", (Throwable)e);
        }
    }
}

