/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.regression.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.OpType;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.OP_TYPE;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.regression.compiler.factories.KiePMMLRegressionTableRegressionFactory;
import org.kie.pmml.models.regression.model.enums.REGRESSION_NORMALIZATION_METHOD;
import org.kie.pmml.models.regression.model.tuples.KiePMMLTableSourceCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLRegressionTableClassificationFactory {
    public static final String KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE_JAVA = "KiePMMLRegressionTableClassificationTemplate.tmpl";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLRegressionTableClassificationFactory.class.getName());
    private static final String MAIN_CLASS_NOT_FOUND = "Main class not found";
    private static final String KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE_JAVA = "KiePMMLGetProbabilityMapMethodTemplate.tmpl";
    private static final String KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE = "KiePMMLGetProbabilityMapMethodTemplate";
    private static final String KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE = "KiePMMLRegressionTableClassificationTemplate";
    private static AtomicInteger classArity = new AtomicInteger(0);
    private static CompilationUnit templateEvaluate;
    private static CompilationUnit cloneEvaluate;

    private KiePMMLRegressionTableClassificationFactory() {
    }

    public static Map<String, KiePMMLTableSourceCategory> getRegressionTables(List<RegressionTable> regressionTables, RegressionModel.NormalizationMethod normalizationMethod, OpType opType, List<KiePMMLOutputField> outputFields, String targetField, String packageName) throws IOException {
        logger.trace("getRegressionTables {}", regressionTables);
        CompilationUnit templateCU = JavaParserUtils.getFromFileName((String)KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE_JAVA);
        Map<String, KiePMMLTableSourceCategory> toReturn = KiePMMLRegressionTableRegressionFactory.getRegressionTables(regressionTables, RegressionModel.NormalizationMethod.NONE, targetField, packageName);
        Map.Entry<String, String> regressionTableEntry = KiePMMLRegressionTableClassificationFactory.getRegressionTable(templateCU, toReturn, normalizationMethod, opType, outputFields, targetField, packageName);
        toReturn.put(regressionTableEntry.getKey(), new KiePMMLTableSourceCategory(regressionTableEntry.getValue(), ""));
        return toReturn;
    }

    public static Map.Entry<String, String> getRegressionTable(CompilationUnit templateCU, Map<String, KiePMMLTableSourceCategory> regressionTablesMap, RegressionModel.NormalizationMethod normalizationMethod, OpType opType, List<KiePMMLOutputField> outputFields, String targetField, String packageName) throws IOException {
        logger.trace("getRegressionTable {}", regressionTablesMap);
        CompilationUnit cloneCU = templateCU.clone();
        cloneCU.setPackageDeclaration(packageName);
        REGRESSION_NORMALIZATION_METHOD regressionNormalizationMethod = REGRESSION_NORMALIZATION_METHOD.byName((String)normalizationMethod.value());
        OP_TYPE op_type = opType != null ? OP_TYPE.byName((String)opType.value()) : null;
        ClassOrInterfaceDeclaration tableTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_REGRESSION_TABLE_CLASSIFICATION_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
        String className = "KiePMMLRegressionTableClassification" + classArity.addAndGet(1);
        tableTemplate.setName(className);
        KiePMMLRegressionTableClassificationFactory.populateGetProbabilityMapMethod(normalizationMethod, tableTemplate);
        KiePMMLRegressionTableClassificationFactory.populateOutputFieldsMap(tableTemplate, outputFields);
        KiePMMLRegressionTableClassificationFactory.populateIsBinaryMethod(opType, regressionTablesMap.size(), tableTemplate);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)tableTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", tableTemplate.getName())));
        KiePMMLRegressionTableClassificationFactory.setConstructor(constructorDeclaration, tableTemplate.getName(), targetField, regressionNormalizationMethod, op_type);
        KiePMMLRegressionTableClassificationFactory.addMapPopulation(constructorDeclaration.getBody(), regressionTablesMap);
        KiePMMLRegressionTableRegressionFactory.populateGetTargetCategory(tableTemplate, null);
        return new AbstractMap.SimpleEntry<String, String>(className, cloneCU.toString());
    }

    private static void setConstructor(ConstructorDeclaration constructorDeclaration, SimpleName generatedClassName, String targetField, REGRESSION_NORMALIZATION_METHOD regressionNormalizationMethod, OP_TYPE opType) {
        constructorDeclaration.setName(generatedClassName);
        BlockStmt body = constructorDeclaration.getBody();
        List assignExprs = body.findAll(AssignExpr.class);
        assignExprs.forEach(assignExpr -> {
            String propertyName;
            switch (propertyName = assignExpr.getTarget().asNameExpr().getNameAsString()) {
                case "targetField": {
                    assignExpr.setValue((Expression)new StringLiteralExpr(targetField));
                    break;
                }
                case "regressionNormalizationMethod": {
                    assignExpr.setValue((Expression)new NameExpr(regressionNormalizationMethod.getClass().getSimpleName() + "." + regressionNormalizationMethod.name()));
                    break;
                }
                case "opType": {
                    if (opType == null) break;
                    assignExpr.setValue((Expression)new NameExpr(opType.getClass().getSimpleName() + "." + opType.name()));
                    break;
                }
                default: {
                    logger.warn("Unexpected property inside the constructor: {}", (Object)propertyName);
                }
            }
        });
    }

    private static void addMapPopulation(BlockStmt body, Map<String, KiePMMLTableSourceCategory> regressionTablesMap) {
        regressionTablesMap.forEach((className, tableSourceCategory) -> {
            ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
            objectCreationExpr.setType(className);
            NodeList expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(tableSourceCategory.getCategory()), objectCreationExpr});
            body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("categoryTableMap"), "put", expressions));
        });
    }

    private static void populateOutputFieldsMap(ClassOrInterfaceDeclaration tableTemplate, List<KiePMMLOutputField> outputFields) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)tableTemplate.getMethodsByName("populateOutputFieldsMap").get(0);
        BlockStmt body = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing body in %s", methodDeclaration.getName())));
        KiePMMLRegressionTableClassificationFactory.populateOutputFieldsMap(body, outputFields);
    }

    private static void populateOutputFieldsMap(BlockStmt body, List<KiePMMLOutputField> outputFields) {
        outputFields.forEach(outputField -> {
            NodeList expressions;
            StringLiteralExpr key = new StringLiteralExpr(outputField.getName());
            MethodCallExpr value = null;
            switch (outputField.getResultFeature()) {
                case PREDICTED_VALUE: {
                    value = new MethodCallExpr((Expression)new NameExpr("predictedEntry"), "getKey");
                    break;
                }
                case PROBABILITY: {
                    if (outputField.getValue() != null) {
                        expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr(outputField.getValue().toString())});
                        value = new MethodCallExpr((Expression)new NameExpr("probabilityMap"), "get", expressions);
                        break;
                    }
                    if (!outputField.getTargetField().isPresent()) break;
                    expressions = NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr((String)outputField.getTargetField().get())});
                    value = new MethodCallExpr((Expression)new NameExpr("probabilityMap"), "get", expressions);
                    break;
                }
                default: {
                    throw new KiePMMLInternalException(String.format("%s not managed, yet!", outputField.getResultFeature()));
                }
            }
            if (value != null) {
                expressions = NodeList.nodeList((Node[])new Expression[]{key, value});
                body.addStatement((Expression)new MethodCallExpr((Expression)new NameExpr("outputFieldsMap"), "put", expressions));
            }
        });
    }

    private static void populateGetProbabilityMapMethod(RegressionModel.NormalizationMethod normalizationMethod, ClassOrInterfaceDeclaration tableTemplate) {
        try {
            String methodName = String.format("get%sProbabilityMap", normalizationMethod.name());
            templateEvaluate = JavaParserUtils.getFromFileName((String)KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE_JAVA);
            cloneEvaluate = templateEvaluate.clone();
            ClassOrInterfaceDeclaration evaluateTemplateClass = (ClassOrInterfaceDeclaration)cloneEvaluate.getClassByName(KIE_PMML_GET_PROBABILITY_MAP_METHOD_TEMPLATE).orElseThrow(() -> new RuntimeException(MAIN_CLASS_NOT_FOUND));
            MethodDeclaration toReturn = (MethodDeclaration)evaluateTemplateClass.getMethodsByName(methodName).get(0);
            KiePMMLRegressionTableRegressionFactory.addMethod(toReturn, tableTemplate, "getProbabilityMap");
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(e.getMessage());
        }
    }

    private static void populateIsBinaryMethod(OpType opType, int size, ClassOrInterfaceDeclaration tableTemplate) {
        try {
            MethodDeclaration methodDeclaration = (MethodDeclaration)tableTemplate.getMethodsByName("isBinary").get(0);
            boolean toReturn = Objects.equals(OpType.CATEGORICAL, opType) && size == 2;
            BlockStmt blockStmt = new BlockStmt();
            blockStmt.addStatement((Statement)new ReturnStmt((Expression)new BooleanLiteralExpr(toReturn)));
            methodDeclaration.setBody(blockStmt);
        }
        catch (Exception e) {
            throw new KiePMMLInternalException(e.getMessage());
        }
    }
}

