/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;

public class KiePMMLMiningModel
extends KiePMMLModel
implements HasNestedModels {
    public static final PMML_MODEL PMML_MODEL_TYPE = PMML_MODEL.MINING_MODEL;
    private static final long serialVersionUID = 1074200573309922605L;
    protected String algorithmName;
    protected boolean scorable = true;
    protected KiePMMLSegmentation segmentation;

    protected KiePMMLMiningModel(String fileName, String name, List<KiePMMLExtension> extensions) {
        super(fileName, name, extensions);
    }

    public static Builder builder(String fileName, String name, List<KiePMMLExtension> extensions, MINING_FUNCTION miningFunction) {
        return new Builder(fileName, name, extensions, miningFunction);
    }

    public Object evaluate(Map<String, Object> requestData, PMMLRuntimeContext pmmlContext) {
        throw new KiePMMLException("KiePMMLMiningModel is not meant to be used for actual evaluation");
    }

    public List<KiePMMLModel> getNestedModels() {
        return this.getSegmentation().getSegments().stream().map(KiePMMLSegment::getModel).collect(Collectors.toList());
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public boolean isScorable() {
        return this.scorable;
    }

    public KiePMMLSegmentation getSegmentation() {
        return this.segmentation;
    }

    public String toString() {
        return "KiePMMLMiningModel{miningFunction=" + this.miningFunction + ", algorithmName='" + this.algorithmName + "', scorable=" + this.scorable + ", segmentation=" + this.segmentation + ", pmmlMODEL=" + this.pmmlMODEL + ", name='" + this.name + "', id='" + this.id + "', parentId='" + this.parentId + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KiePMMLMiningModel that = (KiePMMLMiningModel)((Object)o);
        if (this.scorable != that.scorable) {
            return false;
        }
        if (this.miningFunction != that.miningFunction) {
            return false;
        }
        if (!Objects.equals(this.algorithmName, that.algorithmName)) {
            return false;
        }
        return Objects.equals((Object)this.segmentation, (Object)that.segmentation);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.miningFunction != null ? this.miningFunction.hashCode() : 0);
        result = 31 * result + (this.algorithmName != null ? this.algorithmName.hashCode() : 0);
        result = 31 * result + (this.scorable ? 1 : 0);
        result = 31 * result + (this.segmentation != null ? this.segmentation.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends KiePMMLModel.Builder<KiePMMLMiningModel> {
        private Builder(String fileName, String name, List<KiePMMLExtension> extensions, MINING_FUNCTION miningFunction) {
            super("MiningModel-", PMML_MODEL_TYPE, miningFunction, () -> new KiePMMLMiningModel(fileName, name, extensions));
        }

        public Builder withAlgorithmName(String algorithmName) {
            ((KiePMMLMiningModel)this.toBuild).algorithmName = algorithmName;
            return this;
        }

        public Builder withScorable(boolean scorable) {
            ((KiePMMLMiningModel)this.toBuild).scorable = scorable;
            return this;
        }

        public Builder withSegmentation(KiePMMLSegmentation segmentation) {
            ((KiePMMLMiningModel)this.toBuild).segmentation = segmentation;
            return this;
        }

        public Builder withTargetField(String targetField) {
            return (Builder)super.withTargetField(targetField);
        }
    }
}

