/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.scorecard.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.MINING_FUNCTION;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;

public class KiePMMLScorecardModel
extends KiePMMLDroolsModel {
    public static final PMML_MODEL PMML_MODEL_TYPE = PMML_MODEL.SCORECARD_MODEL;

    protected KiePMMLScorecardModel(String modelName, List<KiePMMLExtension> extensions) {
        super(modelName, extensions);
    }

    public static Builder builder(String name, List<KiePMMLExtension> extensions, MINING_FUNCTION miningFunction) {
        return new Builder(name, extensions, miningFunction);
    }

    public static PMML_MODEL getPmmlModelType() {
        return PMML_MODEL_TYPE;
    }

    public Object evaluate(Object knowledgeBase, Map<String, Object> requestData) {
        PMML4Result toReturn = (PMML4Result)super.evaluate(knowledgeBase, requestData);
        this.populateWithOutputFields(toReturn);
        return toReturn;
    }

    protected void populateWithOutputFields(PMML4Result toPopulate) {
        if (this.outputFields != null) {
            Map sortedByValue = this.outputFieldsMap.entrySet().stream().filter(entry -> entry.getValue() instanceof Double && (Double)entry.getValue() > 0.0).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), (Double)entry.getValue())).sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            ArrayList orderedReasonCodes = new ArrayList(sortedByValue.keySet());
            for (KiePMMLOutputField outputField : this.outputFields) {
                switch (outputField.getResultFeature()) {
                    case REASON_CODE: {
                        if (outputField.getRank() == null) break;
                        int index = outputField.getRank() - 1;
                        String resultCode = null;
                        String resultVariableName = outputField.getName();
                        if (index < orderedReasonCodes.size()) {
                            resultCode = (String)orderedReasonCodes.get(index);
                        }
                        toPopulate.updateResultVariable(resultVariableName, resultCode);
                        break;
                    }
                }
            }
        }
    }

    public static class Builder
    extends KiePMMLDroolsModel.Builder<KiePMMLScorecardModel> {
        private Builder(String name, List<KiePMMLExtension> extensions, MINING_FUNCTION miningFunction) {
            super("Scorecard-", PMML_MODEL_TYPE, miningFunction, () -> new KiePMMLScorecardModel(name, extensions));
        }
    }
}

