/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.scorecard.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.scorecard.Scorecard;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.dto.DroolsCompilationDTO;
import org.kie.pmml.models.drools.scorecard.compiler.factories.KiePMMLScorecardModelASTFactory;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLDroolsModelFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLScorecardModelFactory {
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA = "KiePMMLScorecardModelTemplate.tmpl";
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE = "KiePMMLScorecardModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLScorecardModelFactory.class.getName());

    private KiePMMLScorecardModelFactory() {
    }

    public static Map<String, String> getKiePMMLScorecardModelSourcesMap(DroolsCompilationDTO<Scorecard> compilationDTO) {
        logger.trace("getKiePMMLScorecardModelSourcesMap {} {} {}", new Object[]{compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getPackageName()});
        CompilationUnit cloneCU = KiePMMLDroolsModelFactoryUtils.getKiePMMLModelCompilationUnit(compilationDTO, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE);
        String className = compilationDTO.getSimpleClassName();
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        KiePMMLScorecardModelFactory.setConstructor(compilationDTO, modelTemplate);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        String fullClassName = compilationDTO.getPackageCanonicalClassName();
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    public static KiePMMLDroolsAST getKiePMMLDroolsAST(List<Field<?>> fields, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLDroolsType> types) {
        logger.trace("getKiePMMLDroolsAST {}", (Object)model);
        return KiePMMLScorecardModelASTFactory.getKiePMMLDroolsAST(fields, model, fieldTypeMap, types);
    }

    static void setConstructor(DroolsCompilationDTO<Scorecard> compilationDTO, ClassOrInterfaceDeclaration modelTemplate) {
        KiePMMLModelFactoryUtils.init(compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
    }
}

