/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.scorecard.compiler.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.False;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.drools.util.StringUtils;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.tuples.KiePMMLReasonCodeAndValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLScorecardModelCharacteristicASTFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLScorecardModelCharacteristicASTFactory.class.getName());
    private final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;
    private final List<OutputField> outputFields;
    private final DATA_TYPE targetType;
    private boolean useReasonCodes = false;
    private Number baselineScore;
    private REASONCODE_ALGORITHM reasonCodeAlgorithm;

    private KiePMMLScorecardModelCharacteristicASTFactory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<OutputField> outputFields, DATA_TYPE targetType) {
        this.fieldTypeMap = fieldTypeMap;
        this.outputFields = outputFields;
        this.targetType = targetType;
    }

    public static KiePMMLScorecardModelCharacteristicASTFactory factory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<OutputField> outputFields, DATA_TYPE targetType) {
        return new KiePMMLScorecardModelCharacteristicASTFactory(fieldTypeMap, outputFields, targetType);
    }

    public KiePMMLScorecardModelCharacteristicASTFactory withReasonCodes(Number baselineScore, REASONCODE_ALGORITHM reasonCodeAlgorithm) {
        this.useReasonCodes = true;
        this.baselineScore = baselineScore;
        this.reasonCodeAlgorithm = reasonCodeAlgorithm;
        return this;
    }

    public List<KiePMMLDroolsRule> declareRulesFromCharacteristics(Characteristics characteristics, String parentPath, Number initialScore) {
        logger.trace("declareRulesFromCharacteristics {} {} {}", new Object[]{characteristics, parentPath, initialScore});
        ArrayList<KiePMMLDroolsRule> toReturn = new ArrayList<KiePMMLDroolsRule>();
        List characteristicList = characteristics.getCharacteristics();
        for (int i = 0; i < characteristicList.size(); ++i) {
            Characteristic characteristic = (Characteristic)characteristicList.get(i);
            if (i == 0) {
                String statusConstraint = StringUtils.isEmpty((CharSequence)parentPath) ? "status == null" : String.format("status == \"%s\"", parentPath);
                String currentRule = String.format("%s_%s", parentPath, characteristic.getName());
                KiePMMLDroolsRule.Builder builder = KiePMMLDroolsRule.builder((String)currentRule, (String)currentRule, null).withStatusConstraint(statusConstraint);
                if (initialScore != null) {
                    builder = builder.withAccumulation(initialScore);
                }
                toReturn.add(builder.build());
            }
            boolean isLastCharacteristic = i == characteristicList.size() - 1;
            String statusToSet = isLastCharacteristic ? "DONE" : String.format("%s_%s", parentPath, ((Characteristic)characteristicList.get(i + 1)).getName());
            this.declareRuleFromCharacteristic(characteristic, parentPath, toReturn, statusToSet, isLastCharacteristic);
        }
        return toReturn;
    }

    protected void declareRuleFromCharacteristic(Characteristic characteristic, String parentPath, List<KiePMMLDroolsRule> rules, String statusToSet, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromCharacteristic {} {}", (Object)characteristic, (Object)parentPath);
        String currentRule = String.format("%s_%s", parentPath, characteristic.getName());
        List attributes = characteristic.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            this.declareRuleFromAttribute((Attribute)attributes.get(i), currentRule, i, rules, statusToSet, characteristic.getReasonCode(), characteristic.getBaselineScore(), isLastCharacteristic);
        }
    }

    protected void declareRuleFromAttribute(Attribute attribute, String parentPath, int attributeIndex, List<KiePMMLDroolsRule> rules, String statusToSet, String characteristicReasonCode, Number characteristicBaselineScore, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromAttribute {} {}", (Object)attribute, (Object)parentPath);
        Predicate predicate = attribute.getPredicate();
        if (predicate instanceof False) {
            return;
        }
        String currentRule = String.format("%s_%s", parentPath, attributeIndex);
        KiePMMLReasonCodeAndValue reasonCodeAndValue = this.getKiePMMLReasonCodeAndValue(attribute, characteristicReasonCode, characteristicBaselineScore);
        PredicateASTFactoryData predicateASTFactoryData = new PredicateASTFactoryData(predicate, this.outputFields, rules, parentPath, currentRule, this.fieldTypeMap);
        KiePMMLPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromPredicate(attribute.getPartialScore(), statusToSet, reasonCodeAndValue, isLastCharacteristic);
    }

    protected KiePMMLReasonCodeAndValue getKiePMMLReasonCodeAndValue(Attribute attribute, String characteristicReasonCode, Number characteristicBaselineScore) {
        double partialScoreToUse;
        String reasonCode;
        if (!this.useReasonCodes) {
            return null;
        }
        if (characteristicBaselineScore == null && this.baselineScore == null) {
            throw new KiePMMLException("Missing default and characteristic defined baselineScore needed for useReasonCodes == true");
        }
        if (this.reasonCodeAlgorithm == null) {
            throw new KiePMMLException("Missing reasonCodeAlgorithm needed for useReasonCodes == true");
        }
        String string = reasonCode = attribute.getReasonCode() != null && !attribute.getReasonCode().isEmpty() ? attribute.getReasonCode() : characteristicReasonCode;
        if (reasonCode == null || reasonCode.isEmpty()) {
            throw new KiePMMLException("Missing reasonCode needed for useReasonCodes == true");
        }
        double baseLineScoreToUse = characteristicBaselineScore != null ? characteristicBaselineScore.doubleValue() : this.baselineScore.doubleValue();
        double d = partialScoreToUse = attribute.getPartialScore() != null ? attribute.getPartialScore().doubleValue() : 0.0;
        baseLineScoreToUse = REASONCODE_ALGORITHM.POINTS_BELOW.equals((Object)this.reasonCodeAlgorithm) ? (baseLineScoreToUse -= partialScoreToUse) : partialScoreToUse - baseLineScoreToUse;
        return new KiePMMLReasonCodeAndValue(reasonCode, baseLineScoreToUse);
    }
}

