/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.scorecard.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.scorecard.Scorecard;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.scorecard.compiler.factories.KiePMMLScorecardModelASTFactory;
import org.kie.pmml.models.drools.scorecard.model.KiePMMLScorecardModel;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLDroolsModelFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLScorecardModelFactory {
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA = "KiePMMLScorecardModelTemplate.tmpl";
    static final String KIE_PMML_SCORECARD_MODEL_TEMPLATE = "KiePMMLScorecardModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLScorecardModelFactory.class.getName());

    private KiePMMLScorecardModelFactory() {
    }

    public static KiePMMLScorecardModel getKiePMMLScorecardModel(List<Field<?>> fields, TransformationDictionary transformationDictionary, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, String packageName, HasClassLoader hasClassLoader) throws IllegalAccessException, InstantiationException {
        logger.trace("getKiePMMLScorecardModel {} {}", (Object)packageName, (Object)model);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        Map<String, String> sourcesMap = KiePMMLScorecardModelFactory.getKiePMMLScorecardModelSourcesMap(fields, transformationDictionary, model, fieldTypeMap, packageName);
        String fullClassName = packageName + "." + className;
        try {
            Class kiePMMLScorecardModelClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLScorecardModel)kiePMMLScorecardModelClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLScorecardModelSourcesMap(List<Field<?>> fields, TransformationDictionary transformationDictionary, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, String packageName) {
        logger.trace("getKiePMMLScorecardModelSourcesMap {} {} {}", new Object[]{fields, model, packageName});
        CompilationUnit cloneCU = KiePMMLDroolsModelFactoryUtils.getKiePMMLModelCompilationUnit(fields, (Model)model, fieldTypeMap, (String)packageName, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_SCORECARD_MODEL_TEMPLATE);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        KiePMMLScorecardModelFactory.setConstructor(model, fields, transformationDictionary, modelTemplate);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        String fullClassName = packageName + "." + className;
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    public static KiePMMLDroolsAST getKiePMMLDroolsAST(List<Field<?>> fields, Scorecard model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLDroolsType> types) {
        logger.trace("getKiePMMLDroolsAST {}", (Object)model);
        return KiePMMLScorecardModelASTFactory.getKiePMMLDroolsAST(fields, model, fieldTypeMap, types);
    }

    static void setConstructor(Scorecard scorecard, List<Field<?>> fields, TransformationDictionary transformationDictionary, ClassOrInterfaceDeclaration modelTemplate) {
        KiePMMLModelCodegenUtils.init((ClassOrInterfaceDeclaration)modelTemplate, fields, (TransformationDictionary)transformationDictionary, (Model)scorecard);
    }
}

