/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.utils;

import java.io.File;
import org.kie.efesto.common.api.utils.FileUtils;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoFileResource;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.api.utils.SPIUtils;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.compiler.PMMLCompilationContextImpl;
import org.kie.pmml.evaluator.core.service.PMMLRuntimeInternalImpl;

public class PMMLRuntimeFactoryImpl
implements PMMLRuntimeFactory {
    private static final CompilationManager compilationManager = (CompilationManager)SPIUtils.getCompilationManager((boolean)false).get();

    public PMMLRuntime getPMMLRuntimeFromFile(File pmmlFile) {
        EfestoFileResource efestoFileResource = new EfestoFileResource(pmmlFile);
        KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
        PMMLCompilationContextImpl pmmlContext = new PMMLCompilationContextImpl(pmmlFile.getName(), memoryCompilerClassLoader);
        compilationManager.processResource((EfestoCompilationContext)pmmlContext, new EfestoResource[]{efestoFileResource});
        return new PMMLRuntimeInternalImpl();
    }

    public PMMLRuntime getPMMLRuntimeFromClasspath(String pmmlFileName) {
        File pmmlFile = FileUtils.getFile((String)pmmlFileName);
        return this.getPMMLRuntimeFromFile(pmmlFile);
    }
}

