/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.executor;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLFactoryModel;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.factories.KiePMMLFactoryFactory;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLCompilerImpl
implements PMMLCompiler {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLCompilerImpl.class.getName());

    @Override
    public List<KiePMMLModel> getKiePMMLModelsWithSources(String packageName, InputStream inputStream, String fileName, PMMLCompilationContext pmmlContext) {
        logger.trace("getModels {} {}", (Object)inputStream, (Object)pmmlContext);
        try {
            PMML commonPMMLModel = KiePMMLUtil.load((InputStream)inputStream, (String)fileName);
            List models = commonPMMLModel.getModels();
            List<KiePMMLModel> toReturn = this.getModelsWithSources(packageName, commonPMMLModel, pmmlContext, fileName);
            List toAdd = toReturn.stream().map(kiePMMLModel -> this.getKiePMMLFactoryModel((KiePMMLModel)kiePMMLModel, models, packageName)).collect(Collectors.toList());
            toReturn.addAll(toAdd);
            return toReturn;
        }
        catch (KiePMMLInternalException e) {
            throw new KiePMMLException("KiePMMLInternalException", (Throwable)e);
        }
        catch (KiePMMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    private KiePMMLFactoryModel getKiePMMLFactoryModel(KiePMMLModel kiePMMLModel, List<Model> models, String packageName) {
        Set expectedClasses = models.stream().filter(model -> kiePMMLModel.getName().equals(model.getModelName())).map(model -> {
            String modelPackageName = KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", packageName, model.getModelName()));
            return modelPackageName + "." + KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        }).collect(Collectors.toSet());
        HashSet generatedClasses = new HashSet();
        Map<String, Boolean> expectedClassModelTypeMap = expectedClasses.stream().collect(Collectors.toMap(expectedClass -> expectedClass, expectedClass -> {
            HasSourcesMap retrieved = this.getHasSourceMap(kiePMMLModel, (String)expectedClass);
            generatedClasses.addAll(retrieved.getSourcesMap().keySet());
            return retrieved.isInterpreted();
        }));
        if (!generatedClasses.containsAll(expectedClasses)) {
            expectedClasses.removeAll(generatedClasses);
            String missingClasses = String.join((CharSequence)", ", expectedClasses);
            throw new KiePMMLException("Expected generated class " + missingClasses + " not found");
        }
        String factoryClassName = KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLModel.getName()) + "Factory";
        Map factorySourceMap = KiePMMLFactoryFactory.getFactorySourceCode((String)factoryClassName, (String)packageName, expectedClassModelTypeMap);
        return new KiePMMLFactoryModel(kiePMMLModel.getFileName(), factoryClassName, packageName, factorySourceMap);
    }

    private List<Map<String, String>> getModelSourcesMap(String packageName, PMML pmml, PMMLCompilationContext pmmlContext, String fileName) {
        logger.trace("getModelSourcesMap {}", (Object)pmml);
        return pmml.getModels().stream().map(model -> {
            CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)packageName, (PMML)pmml, (Model)model, (PMMLCompilationContext)pmmlContext, (String)fileName);
            return KiePMMLModelRetriever.getSourcesMapFromCommonDataAndTransformationDictionaryAndModel((CompilationDTO)compilationDTO);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<KiePMMLModel> getModelsWithSources(String packageName, PMML pmml, PMMLCompilationContext pmmlContext, String fileName) {
        logger.trace("getModels {}", (Object)pmml);
        return pmml.getModels().stream().map(model -> {
            CommonCompilationDTO compilationDTO = CommonCompilationDTO.fromGeneratedPackageNameAndFields((String)packageName, (PMML)pmml, (Model)model, (PMMLCompilationContext)pmmlContext, (String)fileName);
            return KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((CompilationDTO)compilationDTO);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private HasSourcesMap getHasSourceMap(KiePMMLModel kiePMMLModel, String expectedClass) {
        String fullSourceName = String.format("%s.%s", kiePMMLModel.getKModulePackageName(), KiePMMLModelUtils.getSanitizedClassName((String)kiePMMLModel.getName()));
        if (expectedClass.equals(fullSourceName)) {
            if (!(kiePMMLModel instanceof HasSourcesMap)) {
                throw new KiePMMLException(String.format("Expecting %s at this phase", HasSourcesMap.class.getCanonicalName()));
            }
            return (HasSourcesMap)kiePMMLModel;
        }
        return null;
    }
}

