/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.utils.FileNameUtils;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.commons.HasRedirectOutput;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.KiePMMLFactoryModel;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.kie.pmml.compiler.executor.PMMLCompilerImpl;
import org.kie.pmml.compiler.model.EfestoCallableOutputPMMLClassesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLCompilerService {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLCompilerService.class.getName());
    private static final PMMLCompiler PMML_COMPILER = new PMMLCompilerImpl();

    private PMMLCompilerService() {
    }

    static List<EfestoCompilationOutput> getEfestoFinalOutputPMML(List<KiePMMLModel> kiePmmlModels, String originalFileName, PMMLCompilationContext pmmlContext) {
        List<KiePMMLModelWithSources> kiePmmlModelsWithSources = kiePmmlModels.stream().filter(KiePMMLModelWithSources.class::isInstance).map(KiePMMLModelWithSources.class::cast).collect(Collectors.toList());
        String fileName = FileNameUtils.removeSuffix((String)originalFileName);
        HashMap<String, String> allSourcesMap = new HashMap<String, String>();
        ArrayList<EfestoCompilationOutput> toReturn = new ArrayList<EfestoCompilationOutput>();
        PMMLCompilerService.iterateOverKiePmmlModelsWithSources(kiePmmlModelsWithSources, toReturn, allSourcesMap);
        List<KiePMMLFactoryModel> kiePMMLFactoryModels = kiePmmlModels.stream().filter(KiePMMLFactoryModel.class::isInstance).map(KiePMMLFactoryModel.class::cast).collect(Collectors.toList());
        kiePMMLFactoryModels.forEach(kiePMMLFactoryModel -> allSourcesMap.putAll(kiePMMLFactoryModel.getSourcesMap()));
        Map compiledClasses = pmmlContext.compileClasses(allSourcesMap);
        kiePMMLFactoryModels.forEach(kiePMMLFactoryModel -> {
            String modelName = kiePMMLFactoryModel.getName().substring(0, kiePMMLFactoryModel.getName().lastIndexOf("Factory"));
            String basePath = fileName + "/" + modelName;
            FRI fri = new FRI(basePath, "pmml");
            String fullResourceClassName = (String)kiePMMLFactoryModel.getSourcesMap().keySet().iterator().next();
            toReturn.add((EfestoCompilationOutput)new EfestoCallableOutputPMMLClassesContainer(fri, fullResourceClassName, compiledClasses));
        });
        return toReturn;
    }

    static void iterateOverKiePmmlModelsWithSources(List<KiePMMLModelWithSources> toIterate, List<EfestoCompilationOutput> efestoCompilationOutputs, Map<String, String> allSourcesMap) {
        toIterate.forEach(kiePMMLModelWithSources -> {
            Map sourcesMap = kiePMMLModelWithSources.getSourcesMap();
            allSourcesMap.putAll(sourcesMap);
            if (kiePMMLModelWithSources instanceof HasRedirectOutput) {
                efestoCompilationOutputs.add(((HasRedirectOutput)kiePMMLModelWithSources).getRedirectOutput());
            }
            if (kiePMMLModelWithSources instanceof HasNestedModels) {
                List<KiePMMLModelWithSources> nestedKiePmmlModelsWithSources = ((HasNestedModels)kiePMMLModelWithSources).getNestedModels().stream().filter(KiePMMLModelWithSources.class::isInstance).map(KiePMMLModelWithSources.class::cast).collect(Collectors.toList());
                PMMLCompilerService.iterateOverKiePmmlModelsWithSources(nestedKiePmmlModelsWithSources, efestoCompilationOutputs, allSourcesMap);
            }
        });
    }
}

