/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContextImpl;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.api.runtime.PMMLListener;

public class PMMLCompilationContextImpl
extends EfestoCompilationContextImpl<PMMLListener>
implements PMMLCompilationContext {
    public static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final String name;
    private final String fileName;
    private final String fileNameNoSuffix;
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private final Set<PMMLListener> pmmlListeners = new HashSet<PMMLListener>();

    public PMMLCompilationContextImpl(String fileName, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        super(memoryCompilerClassLoader);
        this.name = "Context_" + ID_GENERATOR.incrementAndGet();
        this.fileName = !fileName.endsWith(".pmml") ? fileName + ".pmml" : fileName;
        this.fileNameNoSuffix = this.fileName.substring(0, this.fileName.lastIndexOf(46));
    }

    public PMMLCompilationContextImpl(String fileName, Set<PMMLListener> pmmlListeners, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        this(fileName, memoryCompilerClassLoader);
        this.pmmlListeners.addAll(pmmlListeners);
    }

    public Set<FRI> getFRIForFile() {
        Set allFri = this.friKeySet();
        String matchingBase = "/" + this.fileNameNoSuffix;
        return allFri.stream().filter(fri -> fri.getBasePath().startsWith(matchingBase)).collect(Collectors.toSet());
    }

    public String getName() {
        return this.name;
    }

    public Object get(String identifier) {
        if (identifier == null || identifier.equals("")) {
            return null;
        }
        Object object = null;
        if (this.map.containsKey(identifier)) {
            object = this.map.get(identifier);
        }
        return object;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.memoryCompilerClassLoader.loadClass(className);
    }

    public void set(String identifier, Object value) {
        this.map.put(identifier, value);
    }

    public void remove(String identifier) {
        this.map.remove(identifier);
    }

    public boolean has(String identifier) {
        return this.map.containsKey(identifier);
    }
}

