/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.executor;

import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLFactoryModel;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLFactoryFactory;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.utils.KiePMMLUtil;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLCompilerImpl
implements PMMLCompiler {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLCompilerImpl.class.getName());

    @Override
    public List<KiePMMLModel> getKiePMMLModels(InputStream inputStream, String fileName, Object kbuilder) {
        logger.trace("getModels {} {}", (Object)inputStream, kbuilder);
        try {
            PMML commonPMMLModel = KiePMMLUtil.load((InputStream)inputStream, (String)fileName);
            return this.getModels(commonPMMLModel, kbuilder);
        }
        catch (KiePMMLInternalException e) {
            throw new KiePMMLException("KiePMMLInternalException", (Throwable)e);
        }
        catch (KiePMMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    @Override
    public List<KiePMMLModel> getKiePMMLModelsWithSources(String factoryClassName, String packageName, InputStream inputStream, String fileName, Object kbuilder) {
        logger.trace("getModels {} {}", (Object)inputStream, kbuilder);
        try {
            PMML commonPMMLModel = KiePMMLUtil.load((InputStream)inputStream, (String)fileName);
            Set expectedClasses = commonPMMLModel.getModels().stream().map(model -> packageName + "." + KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName())).collect(Collectors.toSet());
            List<KiePMMLModel> toReturn = this.getModelsWithSources(packageName, commonPMMLModel, kbuilder);
            HashSet generatedClasses = new HashSet();
            toReturn.forEach(kiePMMLModel -> {
                if (!(kiePMMLModel instanceof HasSourcesMap)) {
                    throw new KiePMMLException(String.format("Expecting %s at this phase", HasSourcesMap.class.getCanonicalName()));
                }
                generatedClasses.addAll(((HasSourcesMap)kiePMMLModel).getSourcesMap().keySet());
            });
            if (!generatedClasses.containsAll(expectedClasses)) {
                expectedClasses.removeAll(generatedClasses);
                String missingClasses = String.join((CharSequence)", ", expectedClasses);
                throw new KiePMMLException("Expected generated class " + missingClasses + " not found");
            }
            Map factorySourceMap = KiePMMLFactoryFactory.getFactorySourceCode((String)factoryClassName, (String)packageName, expectedClasses);
            KiePMMLFactoryModel kiePMMLFactoryModel = new KiePMMLFactoryModel(factoryClassName, packageName, factorySourceMap);
            toReturn.add((KiePMMLModel)kiePMMLFactoryModel);
            return toReturn;
        }
        catch (KiePMMLInternalException e) {
            throw new KiePMMLException("KiePMMLInternalException", (Throwable)e);
        }
        catch (KiePMMLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    private List<KiePMMLModel> getModels(PMML pmml, Object kbuilder) {
        logger.trace("getModels {}", (Object)pmml);
        return pmml.getModels().stream().map(model -> KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModel((DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (Model)model, (Object)kbuilder)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<KiePMMLModel> getModelsWithSources(String packageName, PMML pmml, Object kbuilder) {
        logger.trace("getModels {}", (Object)pmml);
        return pmml.getModels().stream().map(model -> KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((String)packageName, (DataDictionary)pmml.getDataDictionary(), (TransformationDictionary)pmml.getTransformationDictionary(), (Model)model, (Object)kbuilder)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

