/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.compiler.commons.factories.KiePMMLApplyInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLConstantInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLDiscretizeInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLFieldRefInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLMapValuesInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLNormContinuousInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLNormDiscreteInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLTextIndexInstanceFactory;

public class KiePMMLExpressionInstanceFactory {
    private KiePMMLExpressionInstanceFactory() {
    }

    public static List<KiePMMLExpression> getKiePMMLExpressions(List<Expression> expressions) {
        return expressions.stream().map(KiePMMLExpressionInstanceFactory::getKiePMMLExpression).collect(Collectors.toList());
    }

    public static KiePMMLExpression getKiePMMLExpression(Expression expression) {
        if (expression instanceof Apply) {
            return KiePMMLApplyInstanceFactory.getKiePMMLApply((Apply)expression);
        }
        if (expression instanceof Constant) {
            return KiePMMLConstantInstanceFactory.getKiePMMLConstant((Constant)expression);
        }
        if (expression instanceof Discretize) {
            return KiePMMLDiscretizeInstanceFactory.getKiePMMLDiscretize((Discretize)expression);
        }
        if (expression instanceof FieldRef) {
            return KiePMMLFieldRefInstanceFactory.getKiePMMLFieldRef((FieldRef)expression);
        }
        if (expression instanceof MapValues) {
            return KiePMMLMapValuesInstanceFactory.getKiePMMLMapValues((MapValues)expression);
        }
        if (expression instanceof NormContinuous) {
            return KiePMMLNormContinuousInstanceFactory.getKiePMMLNormContinuous((NormContinuous)expression);
        }
        if (expression instanceof NormDiscrete) {
            return KiePMMLNormDiscreteInstanceFactory.getKiePMMLNormDiscrete((NormDiscrete)expression);
        }
        if (expression instanceof TextIndex) {
            return KiePMMLTextIndexInstanceFactory.getKiePMMLTextIndex((TextIndex)expression);
        }
        throw new IllegalArgumentException(String.format("Expression %s not managed", expression.getClass()));
    }
}

