/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.api.models.TargetValue;
import org.kie.pmml.compiler.commons.codegenfactories.TargetValueFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class TargetFieldFactory {
    static final String TARGET_FIELD_TEMPLATE_JAVA = "TargetFieldTemplate.tmpl";
    static final String TARGET_FIELD_TEMPLATE = "TargetFieldTemplate";
    static final String GETTARGET_FIELD = "getTargetField";
    static final String TARGET_FIELD = "targetField";
    static final ClassOrInterfaceDeclaration TARGET_TEMPLATE;

    private TargetFieldFactory() {
    }

    static ObjectCreationExpr getTargetFieldVariableInitializer(TargetField targetField) {
        MethodDeclaration methodDeclaration = ((MethodDeclaration)TARGET_TEMPLATE.getMethodsByName(GETTARGET_FIELD).get(0)).clone();
        BlockStmt targetBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(targetBody, TARGET_FIELD).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", TARGET_FIELD, targetBody)));
        variableDeclarator.setName(targetField.getName());
        ObjectCreationExpr toReturn = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", TARGET_FIELD, targetBody)))).asObjectCreationExpr();
        NodeList arguments = new NodeList();
        if (targetField.getTargetValues() != null) {
            for (TargetValue targetValue : targetField.getTargetValues()) {
                arguments.add((Node)TargetValueFactory.getTargetValueVariableInitializer(targetValue));
            }
        }
        toReturn.getArgument(0).asMethodCallExpr().setArguments(arguments);
        OP_TYPE oPT = targetField.getOpType();
        NameExpr opType = oPT != null ? new NameExpr(oPT.getClass().getName() + "." + oPT.name()) : new NullLiteralExpr();
        toReturn.setArgument(1, (Expression)opType);
        toReturn.setArgument(2, CommonCodegenUtils.getExpressionForObject(targetField.getField()));
        CAST_INTEGER cstInt = targetField.getCastInteger();
        NameExpr castInteger = cstInt != null ? new NameExpr(cstInt.getClass().getName() + "." + cstInt.name()) : new NullLiteralExpr();
        toReturn.setArgument(3, (Expression)castInteger);
        toReturn.setArgument(4, CommonCodegenUtils.getExpressionForObject(targetField.getMin()));
        toReturn.setArgument(5, CommonCodegenUtils.getExpressionForObject(targetField.getMax()));
        toReturn.setArgument(6, CommonCodegenUtils.getExpressionForObject(targetField.getRescaleConstant()));
        toReturn.setArgument(7, CommonCodegenUtils.getExpressionForObject(targetField.getRescaleFactor()));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(TARGET_FIELD_TEMPLATE_JAVA);
        TARGET_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(TARGET_FIELD_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: TargetFieldTemplate"));
        ((MethodDeclaration)TARGET_TEMPLATE.getMethodsByName(GETTARGET_FIELD).get(0)).clone();
    }
}

