/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.MapValues;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLFieldColumnPairFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLInlineTableFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLMapValuesFactory {
    static final String KIE_PMML_MAPVALUES_TEMPLATE_JAVA = "KiePMMLMapValuesTemplate.tmpl";
    static final String KIE_PMML_MAPVALUES_TEMPLATE = "KiePMMLMapValuesTemplate";
    static final String GETKIEPMMLMAPVALUES = "getKiePMMLMapValues";
    static final String MAPVALUES = "mapValues";
    static final ClassOrInterfaceDeclaration MAPVALUES_TEMPLATE;

    private KiePMMLMapValuesFactory() {
    }

    static BlockStmt getMapValuesVariableDeclaration(String variableName, MapValues mapValues) {
        NullLiteralExpr dataTypeExpression;
        if (mapValues.getInlineTable() == null && mapValues.getTableLocator() != null) {
            throw new UnsupportedOperationException("TableLocator not supported, yet");
        }
        MethodDeclaration methodDeclaration = ((MethodDeclaration)MAPVALUES_TEMPLATE.getMethodsByName(GETKIEPMMLMAPVALUES).get(0)).clone();
        BlockStmt mapValuesBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(mapValuesBody, MAPVALUES).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", MAPVALUES, mapValuesBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        int counter = 0;
        NodeList arguments = new NodeList();
        if (mapValues.hasFieldColumnPairs()) {
            for (FieldColumnPair fieldColumnPair : mapValues.getFieldColumnPairs()) {
                String nestedVariableName = String.format("%s_%s", variableName, counter);
                arguments.add((Node)new NameExpr(nestedVariableName));
                BlockStmt toAdd = KiePMMLFieldColumnPairFactory.getFieldColumnPairVariableDeclaration(nestedVariableName, fieldColumnPair);
                toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
                ++counter;
            }
        }
        String inlineTableVariableName = String.format("%s_InlineTable", variableName);
        BlockStmt toAdd = KiePMMLInlineTableFactory.getInlineTableVariableDeclaration(inlineTableVariableName, mapValues.getInlineTable());
        toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", MAPVALUES, toReturn)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", initializer);
        StringLiteralExpr nameExpr = new StringLiteralExpr(variableName);
        StringLiteralExpr outputColumnExpr = new StringLiteralExpr(mapValues.getOutputColumn());
        builder.setArgument(0, (Expression)nameExpr);
        builder.setArgument(2, (Expression)outputColumnExpr);
        if (mapValues.getDataType() != null) {
            DATA_TYPE dataType = DATA_TYPE.byName((String)mapValues.getDataType().value());
            dataTypeExpression = new NameExpr(DATA_TYPE.class.getName() + "." + dataType.name());
        } else {
            dataTypeExpression = new NullLiteralExpr();
        }
        CommonCodegenUtils.getChainedMethodCallExprFrom("withDefaultValue", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(mapValues.getDefaultValue()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withMapMissingTo", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(mapValues.getMapMissingTo()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withDataType", initializer).setArgument(0, (Expression)dataTypeExpression);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withKiePMMLInlineTable", initializer).setArgument(0, (Expression)new NameExpr(inlineTableVariableName));
        CommonCodegenUtils.getChainedMethodCallExprFrom("asList", initializer).setArguments(arguments);
        mapValuesBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_MAPVALUES_TEMPLATE_JAVA);
        MAPVALUES_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_MAPVALUES_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLMapValuesTemplate"));
        ((MethodDeclaration)MAPVALUES_TEMPLATE.getMethodsByName(GETKIEPMMLMAPVALUES).get(0)).clone();
    }
}

