/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.compiler.api.provider.ModelImplementationProviderFinder;
import org.kie.pmml.compiler.commons.implementations.ModelImplementationProviderFinderImpl;
import org.kie.pmml.compiler.commons.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLModelRetriever {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLModelRetriever.class.getName());
    private static final ModelImplementationProviderFinder modelImplementationProviderFinder = new ModelImplementationProviderFinderImpl();

    private KiePMMLModelRetriever() {
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Model model, Object kBuilder) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModel {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        return KiePMMLModelRetriever.getModelImplementationProviderStream(model).map(implementation -> implementation.getKiePMMLModel(dataDictionary, transformationDictionary, model, kBuilder)).map(kiePMMLModel -> KiePMMLModelRetriever.getPopulatedWithPMMLModelFields(kiePMMLModel, model.getMiningSchema(), model.getOutput())).findFirst();
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelWithSources(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Model model, Object kBuilder) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModelWithSources {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        return KiePMMLModelRetriever.getModelImplementationProviderStream(model).map(implementation -> implementation.getKiePMMLModelWithSources(packageName, dataDictionary, transformationDictionary, model, kBuilder)).findFirst();
    }

    static KiePMMLModel getPopulatedWithPMMLModelFields(KiePMMLModel toPopulate, MiningSchema miningSchema, Output output) {
        if (miningSchema != null) {
            List miningFields = miningSchema.getMiningFields().stream().map(ModelUtils::convertToKieMiningField).collect(Collectors.toList());
            toPopulate.setMiningFields(miningFields);
        }
        if (output != null) {
            List outputFields = output.getOutputFields().stream().map(ModelUtils::convertToKieOutputField).collect(Collectors.toList());
            toPopulate.setOutputFields(outputFields);
        }
        return toPopulate;
    }

    private static Stream<ModelImplementationProvider<Model, KiePMMLModel>> getModelImplementationProviderStream(Model model) {
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        return modelImplementationProviderFinder.getImplementations(false).stream().filter(implementation -> pmmlMODEL.equals((Object)implementation.getPMMLModelType()));
    }
}

