/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Model;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Target;
import org.kie.pmml.commons.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.enums.DATA_TYPE;
import org.kie.pmml.commons.model.enums.OP_TYPE;
import org.kie.pmml.commons.model.tuples.KiePMMLNameOpType;
import org.kie.pmml.commons.utils.PrimitiveBoxedUtils;

public class ModelUtils {
    private ModelUtils() {
    }

    public static Optional<String> getTargetFieldName(DataDictionary dataDictionary, Model model) {
        return ModelUtils.getTargetFields(dataDictionary, model).stream().map(KiePMMLNameOpType::getName).findFirst();
    }

    public static DATA_TYPE getTargetFieldType(DataDictionary dataDictionary, Model model) {
        return ModelUtils.getTargetFieldsTypeMap(dataDictionary, model).entrySet().iterator().next().getValue();
    }

    public static List<KiePMMLNameOpType> getTargetFields(DataDictionary dataDictionary, Model model) {
        ArrayList<KiePMMLNameOpType> toReturn = new ArrayList<KiePMMLNameOpType>();
        if (model.getTargets() != null && model.getTargets().getTargets() != null) {
            for (Target target : model.getTargets().getTargets()) {
                OP_TYPE opType = target.getOpType() != null ? OP_TYPE.byName((String)target.getOpType().value()) : ModelUtils.getOpType(dataDictionary, model, target.getField().getValue());
                toReturn.add(new KiePMMLNameOpType(target.getField().getValue(), opType));
            }
        } else {
            for (MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                OP_TYPE opType = miningField.getOpType() != null ? OP_TYPE.byName((String)miningField.getOpType().value()) : ModelUtils.getOpType(dataDictionary, model, miningField.getName().getValue());
                toReturn.add(new KiePMMLNameOpType(miningField.getName().getValue(), opType));
            }
        }
        return toReturn;
    }

    public static Map<String, DATA_TYPE> getTargetFieldsTypeMap(DataDictionary dataDictionary, Model model) {
        LinkedHashMap<String, DATA_TYPE> toReturn = new LinkedHashMap<String, DATA_TYPE>();
        if (model.getTargets() != null && model.getTargets().getTargets() != null) {
            for (Target target : model.getTargets().getTargets()) {
                toReturn.put(target.getField().getValue(), ModelUtils.getDataType(dataDictionary, target.getField().getValue()));
            }
        } else {
            for (MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                toReturn.put(miningField.getName().getValue(), ModelUtils.getDataType(dataDictionary, miningField.getName().getValue()));
            }
        }
        return toReturn;
    }

    public static OP_TYPE getOpType(DataDictionary dataDictionary, Model model, String targetFieldName) {
        Optional<OP_TYPE> toReturn = model.getMiningSchema().getMiningFields().stream().filter(dataField -> Objects.equals(targetFieldName, dataField.getName().getValue()) && dataField.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        if (!toReturn.isPresent()) {
            toReturn = dataDictionary.getDataFields().stream().filter(dataField -> Objects.equals(targetFieldName, dataField.getName().getValue()) && dataField.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        }
        return toReturn.orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find OpType for field %s", targetFieldName)));
    }

    public static DATA_TYPE getDataType(DataDictionary dataDictionary, String targetFieldName) {
        Optional<DATA_TYPE> toReturn = dataDictionary.getDataFields().stream().filter(dataField -> Objects.equals(targetFieldName, dataField.getName().getValue())).findFirst().map(dataField -> DATA_TYPE.byName((String)dataField.getDataType().value()));
        return toReturn.orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find DataType for field %s", targetFieldName)));
    }

    public static String getBoxedClassName(ParameterField parameterField) {
        return parameterField.getDataType() == null ? Object.class.getName() : ModelUtils.getBoxedClassName(parameterField.getDataType());
    }

    public static String getBoxedClassName(DataType dataType) {
        Class c = dataType == null ? Object.class : DATA_TYPE.byName((String)dataType.value()).getMappedClass();
        return PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed((Class)c).map(primitiveBoxed -> primitiveBoxed.getBoxed().getName()).orElse(c.getName());
    }
}

