/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.implementations;

import java.util.Optional;
import java.util.stream.Stream;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.compiler.api.provider.ModelImplementationProviderFinder;
import org.kie.pmml.compiler.commons.implementations.ModelImplementationProviderFinderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLModelRetriever {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLModelRetriever.class.getName());
    private static final ModelImplementationProviderFinder modelImplementationProviderFinder = new ModelImplementationProviderFinderImpl();

    private KiePMMLModelRetriever() {
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModel(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Model model, Object kBuilder) {
        logger.trace("getFromCommonDataAndTransformationDictionaryAndModel {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        return KiePMMLModelRetriever.getModelImplementationProviderStream(model).map(implementation -> implementation.getKiePMMLModel(dataDictionary, transformationDictionary, model, kBuilder)).findFirst();
    }

    public static Optional<KiePMMLModel> getFromCommonDataAndTransformationDictionaryAndModelFromPlugin(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Model model, Object kBuilder) {
        logger.trace("getFromDataDictionaryAndModel {}", (Object)model);
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        logger.debug("pmmlModelType {}", (Object)pmmlMODEL);
        return KiePMMLModelRetriever.getModelImplementationProviderStream(model).map(implementation -> implementation.getKiePMMLModelFromPlugin(packageName, dataDictionary, transformationDictionary, model, kBuilder)).findFirst();
    }

    private static Stream<ModelImplementationProvider<Model, KiePMMLModel>> getModelImplementationProviderStream(Model model) {
        PMML_MODEL pmmlMODEL = PMML_MODEL.byName((String)model.getClass().getSimpleName());
        return modelImplementationProviderFinder.getImplementations(false).stream().filter(implementation -> pmmlMODEL.equals((Object)implementation.getPMMLModelType()));
    }
}

