/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.Interval;
import org.kie.pmml.api.models.MiningField;

public enum BooleanFunctions {
    IS_MISSING("isMissing"),
    IS_NOT_MISSING("isNotMissing"),
    IS_VALID("isValid"),
    IS_NOT_VALID("isNotValid"),
    EQUAL("equal"),
    NOT_EQUAL("notEqual"),
    LESS_THAN("lessThan"),
    LESS_OR_EQUAL("lessOrEqual"),
    GREATER_THAN("greaterThan"),
    GREATER_OR_EQUAL("greaterOrEqual"),
    AND("and"),
    OR("or"),
    NOT("not"),
    IS_IN("isIn"),
    IS_NOT_IN("isNotIn"),
    IF("if");

    static final List<BooleanFunctions> BOOLEAN_FUNCTIONS_VALIDATION;
    private final String name;

    private BooleanFunctions(String name) {
        this.name = name;
    }

    public static boolean isBooleanFunctions(String name) {
        return Arrays.stream(BooleanFunctions.values()).anyMatch(value -> name.equals(value.name));
    }

    public static boolean isBooleanFunctionsValidation(String name) {
        return BooleanFunctions.isBooleanFunctions(name) && BooleanFunctions.byName(name).isValidation();
    }

    public static BooleanFunctions byName(String name) {
        return Arrays.stream(BooleanFunctions.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find BooleanFunctions with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData, MiningField referredByFieldRef) {
        switch (this) {
            case IS_MISSING: {
                return this.isMissing(inputData, referredByFieldRef);
            }
            case IS_NOT_MISSING: {
                return this.isNotMissing(inputData, referredByFieldRef);
            }
            case IS_VALID: {
                return this.isValid(inputData, referredByFieldRef);
            }
            case IS_NOT_VALID: {
                return this.isNotValid(inputData, referredByFieldRef);
            }
            case EQUAL: {
                return this.equal(inputData);
            }
            case NOT_EQUAL: {
                return this.notEqual(inputData);
            }
            case LESS_THAN: {
                return this.lessThan(inputData);
            }
            case LESS_OR_EQUAL: {
                return this.lessOrEqual(inputData);
            }
            case GREATER_THAN: {
                return this.greaterThan(inputData);
            }
            case GREATER_OR_EQUAL: {
                return this.greaterOrEqual(inputData);
            }
            case AND: {
                return this.and(inputData);
            }
            case OR: {
                return this.or(inputData);
            }
            case NOT: {
                return this.not(inputData);
            }
            case IS_IN: {
                return this.isIn(inputData);
            }
            case IS_NOT_IN: {
                return this.isNotIn(inputData);
            }
            case IF: {
                return this.ifF(inputData);
            }
        }
        throw new KiePMMLException("Unmanaged BooleanFunctions " + this);
    }

    public boolean isValidation() {
        return BOOLEAN_FUNCTIONS_VALIDATION.contains((Object)this);
    }

    private boolean isMissing(Object[] inputData, MiningField referredByFieldRef) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 1);
        if (inputData[0] == null) {
            return true;
        }
        if (this.isValid(inputData, referredByFieldRef)) {
            return false;
        }
        return INVALID_VALUE_TREATMENT_METHOD.AS_MISSING.equals(referredByFieldRef.getInvalidValueTreatmentMethod());
    }

    private boolean isNotMissing(Object[] inputData, MiningField referredByFieldRef) {
        return !this.isMissing(inputData, referredByFieldRef);
    }

    private boolean isValid(Object[] inputData, MiningField referredByFieldRef) {
        List<String> allowedValues;
        BUILTIN_FUNCTIONS.checkLength(inputData, 1);
        if (referredByFieldRef == null) {
            throw new IllegalArgumentException("Expecting MiningField, received null");
        }
        if (inputData[0] == null) {
            return false;
        }
        List<Interval> intervals = referredByFieldRef.getIntervals();
        boolean toReturn = true;
        if (intervals != null && !intervals.isEmpty()) {
            BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
            double a = ((Number)inputData[0]).doubleValue();
            for (Interval interval : intervals) {
                if (!(a >= interval.getLeftMargin().doubleValue()) || !(a <= interval.getRightMargin().doubleValue())) continue;
                return true;
            }
            toReturn = false;
        }
        if ((allowedValues = referredByFieldRef.getAllowedValues()) != null && !allowedValues.isEmpty()) {
            String a = inputData[0].toString();
            if (allowedValues.contains(a)) {
                return true;
            }
            toReturn = false;
        }
        return toReturn;
    }

    private boolean isNotValid(Object[] inputData, MiningField referredByFieldRef) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 1);
        if (inputData[0] == null) {
            return false;
        }
        if (this.isValid(inputData, referredByFieldRef)) {
            return false;
        }
        return !INVALID_VALUE_TREATMENT_METHOD.AS_MISSING.equals(referredByFieldRef.getInvalidValueTreatmentMethod());
    }

    private boolean equal(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkLength(inputData, 2);
        return Objects.equals(inputData[0], inputData[1]);
    }

    private boolean notEqual(Object[] inputData) {
        return !this.equal(inputData);
    }

    private boolean lessThan(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a < b;
    }

    private boolean lessOrEqual(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a <= b;
    }

    private boolean greaterThan(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a > b;
    }

    private boolean greaterOrEqual(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a >= b;
    }

    private boolean and(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkBooleans(inputData, 2);
        boolean a = (Boolean)inputData[0];
        boolean b = (Boolean)inputData[1];
        return a && b;
    }

    private boolean or(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkBooleans(inputData, 2);
        boolean a = (Boolean)inputData[0];
        boolean b = (Boolean)inputData[1];
        return a || b;
    }

    private boolean not(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkBooleans(inputData, 1);
        boolean a = (Boolean)inputData[0];
        return !a;
    }

    private boolean isIn(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkMinimumLength(inputData, 2);
        Object a = inputData[0];
        for (int i = 1; i < inputData.length; ++i) {
            if (!a.equals(inputData[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isNotIn(Object[] inputData) {
        return !this.isIn(inputData);
    }

    private Object ifF(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkRangeLength(inputData, 2, 3);
        if (!(inputData[0] instanceof Boolean)) {
            throw new IllegalArgumentException("Expected Boolean as first parameter");
        }
        boolean a = (Boolean)inputData[0];
        if (a) {
            return inputData[1];
        }
        return inputData.length == 3 ? inputData[2] : null;
    }

    static {
        BOOLEAN_FUNCTIONS_VALIDATION = Arrays.asList(IS_MISSING, IS_NOT_MISSING, IS_VALID, IS_NOT_VALID);
    }
}

