/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.Arrays;
import java.util.OptionalDouble;
import java.util.stream.DoubleStream;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;

public enum ArithmeticFunctions {
    PLUS("+"),
    MINUS("-"),
    MULTI("*"),
    DIVISION("/"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    AVG("avg"),
    MEDIAN("median"),
    PRODUCT("product"),
    LOG10("log10"),
    LN("ln"),
    SQRT("sqrt"),
    ABS("abs"),
    EXP("exp"),
    POW("pow"),
    THRESHOLD("threshold"),
    FLOOR("floor"),
    CEIL("ceil"),
    ROUND("round"),
    MODULO("modulo");

    private final String name;

    private ArithmeticFunctions(String name) {
        this.name = name;
    }

    public static boolean isArithmeticFunctions(String name) {
        return Arrays.stream(ArithmeticFunctions.values()).anyMatch(value -> name.equals(value.name));
    }

    public static ArithmeticFunctions byName(String name) {
        return Arrays.stream(ArithmeticFunctions.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find ArithmeticFunctions with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData) {
        switch (this) {
            case AVG: {
                return this.avg(inputData);
            }
            case MAX: {
                return this.max(inputData);
            }
            case MEDIAN: {
                return this.median(inputData);
            }
            case MIN: {
                return this.min(inputData);
            }
            case MINUS: {
                return this.minus(inputData);
            }
            case MULTI: {
                return this.multi(inputData);
            }
            case DIVISION: {
                return this.division(inputData);
            }
            case PLUS: {
                return this.plus(inputData);
            }
            case PRODUCT: {
                return this.product(inputData);
            }
            case SUM: {
                return this.sum(inputData);
            }
            case LOG10: {
                return this.log10(inputData);
            }
            case LN: {
                return this.ln(inputData);
            }
            case SQRT: {
                return this.sqrt(inputData);
            }
            case ABS: {
                return this.abs(inputData);
            }
            case EXP: {
                return this.exp(inputData);
            }
            case POW: {
                return this.pow(inputData);
            }
            case THRESHOLD: {
                return this.threshold(inputData);
            }
            case FLOOR: {
                return this.floor(inputData);
            }
            case CEIL: {
                return this.ceil(inputData);
            }
            case ROUND: {
                return this.round(inputData);
            }
            case MODULO: {
                return this.modulo(inputData);
            }
        }
        throw new KiePMMLException("Unmanaged ArithmeticFunctions " + this);
    }

    private double avg(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).average().orElseThrow(() -> new IllegalArgumentException("Failed to find average value"));
    }

    private double division(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a / b;
    }

    private double max(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).max().orElseThrow(() -> new KieEnumException("Failed to find maximum value"));
    }

    private double median(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, inputData.length);
        DoubleStream sortedValues = Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).sorted();
        OptionalDouble toReturn = inputData.length % 2 == 0 ? sortedValues.skip((long)(inputData.length / 2) - 1L).limit(2L).average() : sortedValues.skip(inputData.length / 2).findFirst();
        return toReturn.orElseThrow(() -> new KieEnumException("Failed to find median value"));
    }

    private double min(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).min().orElseThrow(() -> new KieEnumException("Failed to find minimum value"));
    }

    private double minus(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a - b;
    }

    private double multi(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a * b;
    }

    private double plus(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a + b;
    }

    private double product(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).reduce(1.0, (a, b) -> a * b);
    }

    private double sum(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, inputData.length);
        return Arrays.stream(inputData).mapToDouble(num -> ((Number)num).doubleValue()).sum();
    }

    private double log10(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.log10(((Number)inputData[0]).doubleValue());
    }

    private double ln(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.log(((Number)inputData[0]).doubleValue());
    }

    private double sqrt(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.sqrt(((Number)inputData[0]).doubleValue());
    }

    private double abs(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.abs(((Number)inputData[0]).doubleValue());
    }

    private double exp(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.exp(((Number)inputData[0]).doubleValue());
    }

    private double pow(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return Math.pow(a, b);
    }

    private double threshold(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a > b ? 1.0 : 0.0;
    }

    private double floor(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.floor(((Number)inputData[0]).doubleValue());
    }

    private double ceil(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.ceil(((Number)inputData[0]).doubleValue());
    }

    private double round(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        return Math.round(((Number)inputData[0]).doubleValue());
    }

    private double modulo(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double a = ((Number)inputData[0]).doubleValue();
        double b = ((Number)inputData[1]).doubleValue();
        return a % b;
    }
}

