/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.models;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.models.TargetValue;

public class TargetField
implements Serializable {
    private static final long serialVersionUID = 7720028373203700981L;
    private final String name = UUID.randomUUID().toString();
    private final List<TargetValue> targetValues;
    private final OP_TYPE opType;
    private final String field;
    private final CAST_INTEGER castInteger;
    private final Double min;
    private final Double max;
    private double rescaleConstant = 0.0;
    private double rescaleFactor = 1.0;

    public TargetField(List<TargetValue> targetValues, OP_TYPE opType, String field, CAST_INTEGER castInteger, Number min, Number max, Number rescaleConstant, Number rescaleFactor) {
        this.targetValues = targetValues;
        this.opType = opType;
        this.field = field;
        this.castInteger = castInteger;
        this.min = min != null ? Double.valueOf(min.doubleValue()) : null;
        Double d = this.max = max != null ? Double.valueOf(max.doubleValue()) : null;
        if (rescaleConstant != null) {
            this.rescaleConstant = rescaleConstant.doubleValue();
        }
        if (rescaleFactor != null) {
            this.rescaleFactor = rescaleFactor.doubleValue();
        }
    }

    public String getName() {
        return this.name;
    }

    public List<TargetValue> getTargetValues() {
        return this.targetValues != null ? Collections.unmodifiableList(this.targetValues) : Collections.emptyList();
    }

    public OP_TYPE getOpType() {
        return this.opType;
    }

    public String getField() {
        return this.field;
    }

    public CAST_INTEGER getCastInteger() {
        return this.castInteger;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public double getRescaleConstant() {
        return this.rescaleConstant;
    }

    public double getRescaleFactor() {
        return this.rescaleFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetField that = (TargetField)o;
        return Double.compare(that.rescaleConstant, this.rescaleConstant) == 0 && Double.compare(that.rescaleFactor, this.rescaleFactor) == 0 && Objects.equals(this.name, that.name) && Objects.equals(this.targetValues, that.targetValues) && this.opType == that.opType && Objects.equals(this.field, that.field) && this.castInteger == that.castInteger && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targetValues, this.opType, this.field, this.castInteger, this.min, this.max, this.rescaleConstant, this.rescaleFactor);
    }

    public String toString() {
        return "TargetField{name='" + this.name + "', targetValues=" + this.targetValues + ", opType=" + this.opType + ", field='" + this.field + "', castInteger=" + this.castInteger + ", min=" + this.min + ", max=" + this.max + ", rescaleConstant=" + this.rescaleConstant + ", rescaleFactor=" + this.rescaleFactor + "}";
    }
}

