/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.kie.memorycompiler.KieMemoryCompilerClassLoader;
import org.kie.memorycompiler.KieMemoryCompilerException;
import org.kie.memorycompiler.KieMemoryCompilerFileManager;
import org.kie.memorycompiler.KieMemoryCompilerSourceCode;

public class KieMemoryCompiler {
    private static final JavaCompiler JAVA_COMPILER = ToolProvider.getSystemJavaCompiler();
    private static final List<String> OPTIONS = Arrays.asList("-source", "1.8", "-target", "1.8", "-encoding", "UTF-8");

    private KieMemoryCompiler() {
    }

    public static Map<String, Class<?>> compile(Map<String, String> classNameSourceMap, ClassLoader classLoader) {
        Map<String, KieMemoryCompilerSourceCode> sourceCodes = classNameSourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new KieMemoryCompilerSourceCode((String)entry.getKey(), (String)entry.getValue())));
        KieMemoryCompilerClassLoader kieMemoryCompilerClassLoader = new KieMemoryCompilerClassLoader(classLoader);
        DiagnosticCollector<JavaFileObject> collector = new DiagnosticCollector<JavaFileObject>();
        KieMemoryCompilerFileManager fileManager = new KieMemoryCompilerFileManager(JAVA_COMPILER.getStandardFileManager(null, null, null), kieMemoryCompilerClassLoader);
        JavaCompiler.CompilationTask task = JAVA_COMPILER.getTask(null, fileManager, collector, OPTIONS, null, sourceCodes.values());
        boolean compilationSuccess = task.call();
        boolean hasCompilerError = collector.getDiagnostics().stream().anyMatch(d -> d.getKind().equals((Object)Diagnostic.Kind.ERROR));
        if (!compilationSuccess || hasCompilerError) {
            KieMemoryCompiler.compilerError(collector);
        }
        HashMap toReturn = new HashMap();
        for (String className : sourceCodes.keySet()) {
            try {
                toReturn.put(className, kieMemoryCompilerClassLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new KieMemoryCompilerException(e.getMessage(), e);
            }
        }
        return toReturn;
    }

    private static void compilerError(DiagnosticCollector<JavaFileObject> collector) {
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append("Compilation failed");
        for (Diagnostic<JavaFileObject> diagnostic : collector.getDiagnostics()) {
            errorBuilder.append(" file: ");
            errorBuilder.append(diagnostic.getSource());
            errorBuilder.append("\r\n");
            errorBuilder.append((Object)diagnostic.getKind());
            errorBuilder.append("; line: ");
            errorBuilder.append(diagnostic.getLineNumber());
            errorBuilder.append("; ");
            errorBuilder.append(diagnostic.getMessage(Locale.US));
        }
        throw new KieMemoryCompilerException(errorBuilder.toString());
    }
}

