/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.ArrayList;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.kie.memorycompiler.KieMemoryCompilerByteCode;
import org.kie.memorycompiler.KieMemoryCompilerClassLoader;
import org.kie.memorycompiler.KieMemoryCompilerException;

public class KieMemoryCompilerFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private List<KieMemoryCompilerByteCode> compiledCode = new ArrayList<KieMemoryCompilerByteCode>();
    private KieMemoryCompilerClassLoader classLoader;

    public KieMemoryCompilerFileManager(JavaFileManager fileManager, KieMemoryCompilerClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        try {
            KieMemoryCompilerByteCode innerClass = new KieMemoryCompilerByteCode(className);
            this.compiledCode.add(innerClass);
            this.classLoader.addCode(innerClass);
            return innerClass;
        }
        catch (Exception e) {
            throw new KieMemoryCompilerException("Error while creating in-memory output file for " + className, e);
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }
}

