/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kie.internal.runtime.conf.BuilderHandler;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.DeploymentDescriptorBuilder;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;

public class DeploymentDescriptorMerger {
    private DeploymentDescriptorMerger() {
    }

    public static DeploymentDescriptor merge(List<DeploymentDescriptor> descriptorHierarchy, MergeMode mode) {
        if (descriptorHierarchy == null || descriptorHierarchy.isEmpty()) {
            throw new IllegalArgumentException("Descriptor hierarchy list cannot be empty");
        }
        if (descriptorHierarchy.size() == 1) {
            return descriptorHierarchy.get(0);
        }
        ArrayDeque<DeploymentDescriptor> stack = new ArrayDeque<DeploymentDescriptor>();
        descriptorHierarchy.forEach(stack::push);
        while (stack.size() > 1) {
            stack.push(DeploymentDescriptorMerger.merge((DeploymentDescriptor)stack.pop(), (DeploymentDescriptor)stack.pop(), mode));
        }
        return (DeploymentDescriptor)stack.pop();
    }

    public static DeploymentDescriptor merge(DeploymentDescriptor primary, DeploymentDescriptor secondary, MergeMode mode) {
        if (primary == null || secondary == null) {
            throw new IllegalArgumentException("Descriptors to merge must be provided");
        }
        if (mode == null) {
            mode = MergeMode.MERGE_COLLECTIONS;
        }
        DeploymentDescriptorBuilder builder = primary.getBuilder();
        builder.setBuildHandler(new MergeModeBuildHandler(mode));
        return switch (mode) {
            case MergeMode.KEEP_ALL -> primary;
            case MergeMode.OVERRIDE_ALL -> secondary;
            case MergeMode.OVERRIDE_EMPTY -> {
                builder.auditMode(secondary.getAuditMode());
                builder.auditPersistenceUnit(secondary.getAuditPersistenceUnit());
                builder.persistenceMode(secondary.getPersistenceMode());
                builder.persistenceUnit(secondary.getPersistenceUnit());
                builder.runtimeStrategy(secondary.getRuntimeStrategy());
                builder.setConfiguration(secondary.getConfiguration());
                builder.setEnvironmentEntries(secondary.getEnvironmentEntries());
                builder.setEventListeners(secondary.getEventListeners());
                builder.setGlobals(secondary.getGlobals());
                builder.setMarshalingStrategies(secondary.getMarshallingStrategies());
                builder.setTaskEventListeners(secondary.getTaskEventListeners());
                builder.setWorkItemHandlers(secondary.getWorkItemHandlers());
                builder.setRequiredRoles(secondary.getRequiredRoles());
                builder.setClasses(secondary.getClasses());
                builder.setLimitSerializationClasses(secondary.getLimitSerializationClasses());
                yield builder.get();
            }
            default -> {
                builder.auditMode(secondary.getAuditMode());
                builder.auditPersistenceUnit(secondary.getAuditPersistenceUnit());
                builder.persistenceMode(secondary.getPersistenceMode());
                builder.persistenceUnit(secondary.getPersistenceUnit());
                builder.runtimeStrategy(secondary.getRuntimeStrategy());
                for (ObjectModel var6_6 : secondary.getEventListeners()) {
                    builder.addEventListener(var6_6);
                }
                for (ObjectModel var6_8 : secondary.getMarshallingStrategies()) {
                    builder.addMarshalingStrategy(var6_8);
                }
                ArrayList<ObjectModel> taskEventListeners = new ArrayList<ObjectModel>(secondary.getTaskEventListeners());
                for (ObjectModel var7_17 : primary.getTaskEventListeners()) {
                    if (taskEventListeners.contains(var7_17)) continue;
                    taskEventListeners.add(var7_17);
                }
                builder.setTaskEventListeners(taskEventListeners);
                for (NamedObjectModel var7_19 : secondary.getConfiguration()) {
                    builder.addConfiguration(var7_19);
                }
                for (NamedObjectModel var7_21 : secondary.getEnvironmentEntries()) {
                    builder.addEnvironmentEntry(var7_21);
                }
                for (NamedObjectModel var7_23 : secondary.getGlobals()) {
                    builder.addGlobal(var7_23);
                }
                for (NamedObjectModel var7_25 : secondary.getWorkItemHandlers()) {
                    builder.addWorkItemHandler(var7_25);
                }
                for (String var7_27 : secondary.getRequiredRoles()) {
                    builder.addRequiredRole(var7_27);
                }
                for (String var7_29 : secondary.getClasses()) {
                    builder.addClass(var7_29);
                }
                Boolean var6_16 = secondary.getLimitSerializationClasses();
                Boolean var7_30 = primary.getLimitSerializationClasses();
                if (!(var6_16 == null || var7_30 == null || var6_16.booleanValue() && var7_30.booleanValue())) {
                    builder.setLimitSerializationClasses(false);
                }
                yield builder.get();
            }
        };
    }

    private static class MergeModeBuildHandler
    implements BuilderHandler {
        private MergeMode mode;

        MergeModeBuildHandler(MergeMode mode) {
            this.mode = mode;
        }

        @Override
        public boolean accepted(Object value) {
            switch (this.mode) {
                case KEEP_ALL: {
                    return false;
                }
                case OVERRIDE_ALL: {
                    return true;
                }
            }
            return !this.isEmpty(value);
        }

        private boolean isEmpty(Object value) {
            if (value == null) {
                return true;
            }
            if (value instanceof String) {
                return ((String)value).isEmpty();
            }
            if (value instanceof Collection) {
                return ((Collection)value).isEmpty();
            }
            return false;
        }
    }
}

