/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.model.Model;
import org.drools.modelcompiler.KieBaseBuilder;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.utils.GeneratedResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EfestoKieSessionUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)EfestoKieSessionUtil.class.getName());

    private EfestoKieSessionUtil() {
    }

    public static KieSession loadKieSession(FRI fri, EfestoRuntimeContext context) {
        logger.debug("loadKieSession {} {}", (Object)fri, (Object)context);
        GeneratedExecutableResource finalResource = (GeneratedExecutableResource)GeneratedResourceUtils.getGeneratedExecutableResource((FRI)fri, (String)"drl").orElseThrow(() -> new KieRuntimeServiceException("Can not find expected GeneratedExecutableResource for " + fri));
        List models = finalResource.getFullClassNames().stream().map(className -> EfestoKieSessionUtil.loadModel(className, context)).collect(Collectors.toList());
        logger.debug("models {}", models);
        InternalKnowledgeBase kieBase = KieBaseBuilder.createKieBaseFromModel(models, (KieBaseOption[])new KieBaseOption[0]);
        logger.debug("kieBase {}", (Object)kieBase);
        try {
            KieSession toReturn = kieBase.newKieSession();
            logger.debug("toReturn {}", (Object)toReturn);
            return toReturn;
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to create new session from %s due to %s", kieBase, e.getMessage());
            logger.error(errorMessage, (Throwable)e);
            throw new KieRuntimeServiceException(errorMessage, (Throwable)e);
        }
    }

    static Model loadModel(String fullModelResourcesSourceClassName, EfestoRuntimeContext context) {
        try {
            Class aClass = context.loadClass(fullModelResourcesSourceClassName);
            return (Model)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new KieRuntimeServiceException((Throwable)e);
        }
    }
}

