/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.runtime.mapinput.utils;

import java.util.Optional;
import org.kie.api.runtime.KieSession;
import org.kie.drl.engine.runtime.mapinput.model.EfestoOutputDrlMap;
import org.kie.drl.engine.runtime.mapinput.utils.MapInputSessionUtils;
import org.kie.drl.engine.runtime.utils.EfestoKieSessionUtil;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.AbstractEfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoMapInputDTO;
import org.kie.efesto.runtimemanager.api.utils.GeneratedResourceUtils;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrlRuntimeHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)DrlRuntimeHelper.class.getName());

    private DrlRuntimeHelper() {
    }

    public static boolean canManage(EfestoInput toEvaluate) {
        return toEvaluate instanceof AbstractEfestoInput && toEvaluate.getInputData() instanceof EfestoMapInputDTO && GeneratedResourceUtils.getGeneratedExecutableResource((FRI)toEvaluate.getFRI(), (String)"drl").isPresent();
    }

    public static Optional<EfestoOutputDrlMap> execute(AbstractEfestoInput<EfestoMapInputDTO> toEvaluate, KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader) {
        KieSession kieSession;
        try {
            kieSession = EfestoKieSessionUtil.loadKieSession((FRI)toEvaluate.getFRI(), (KieMemoryCompiler.MemoryCompilerClassLoader)memoryCompilerClassLoader);
        }
        catch (Exception e) {
            logger.warn("{} can not execute {}", (Object)DrlRuntimeHelper.class.getName(), (Object)toEvaluate.getFRI());
            return Optional.empty();
        }
        if (kieSession == null) {
            return Optional.empty();
        }
        try {
            MapInputSessionUtils.Builder builder = MapInputSessionUtils.builder(kieSession, (EfestoMapInputDTO)toEvaluate.getInputData());
            MapInputSessionUtils mapInputSessionUtils = builder.build();
            String sessionPath = toEvaluate.getFRI().getBasePath() + "/" + kieSession.getIdentifier();
            mapInputSessionUtils.fireAllRules();
            FRI sessionFRI = new FRI(sessionPath, "drl");
            return Optional.of(new EfestoOutputDrlMap(sessionFRI, null));
        }
        catch (Exception e) {
            throw new KieRuntimeServiceException(String.format("%s failed to execute %s", DrlRuntimeHelper.class.getName(), toEvaluate.getFRI()), (Throwable)e);
        }
    }
}

