/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.backend.marshalling.v1x.XStreamMarshaller;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.assembler.DMNResource;
import org.kie.dmn.core.assembler.DMNResourceDependenciesSorter;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.kie.dmn.core.util.DefaultDMNMessagesManager;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.MessageReporter;
import org.kie.dmn.validation.bootstrap.ValidationBootstrapModels;
import org.kie.dmn.validation.dtanalysis.InternalDMNDTAnalyser;
import org.kie.dmn.validation.dtanalysis.InternalDMNDTAnalyserFactory;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DMNValidatorImpl
implements DMNValidator {
    public static final Logger LOG = LoggerFactory.getLogger(DMNValidatorImpl.class);
    static final Schema schemav1_1;
    static final Schema schemav1_2;
    static final Schema schemav1_3;
    private Schema overrideSchema = null;
    private List<DMNMessage> failedInitMsg = new ArrayList<DMNMessage>();
    private final List<DMNProfile> dmnProfiles = new ArrayList<DMNProfile>();
    private final DMNCompilerConfiguration dmnCompilerConfig;
    private final InternalDMNDTAnalyser dmnDTValidator;
    private InternalKnowledgeBase kb11 = KieBaseBuilder.createKieBaseFromModel(Arrays.asList(ValidationBootstrapModels.V1X_MODEL, ValidationBootstrapModels.V11_MODEL), (KieBaseOption[])new KieBaseOption[0]);
    private InternalKnowledgeBase kb12 = KieBaseBuilder.createKieBaseFromModel(Arrays.asList(ValidationBootstrapModels.V1X_MODEL, ValidationBootstrapModels.V12_MODEL), (KieBaseOption[])new KieBaseOption[0]);

    public DMNValidatorImpl(ClassLoader cl, List<DMNProfile> dmnProfiles, Properties p) {
        ChainedProperties localChainedProperties = new ChainedProperties();
        if (p != null) {
            localChainedProperties.addProperties(p);
        }
        this.dmnProfiles.addAll(DMNAssemblerService.getDefaultDMNProfiles((ChainedProperties)localChainedProperties));
        this.dmnProfiles.addAll(dmnProfiles);
        ClassLoader classLoader = cl == null ? ClassLoaderUtil.findDefaultClassLoader() : cl;
        DMNCompilerConfigurationImpl dmnCompilerConfiguration = DMNAssemblerService.compilerConfigWithKModulePrefs((ClassLoader)classLoader, (ChainedProperties)localChainedProperties, this.dmnProfiles, (DMNCompilerConfigurationImpl)((DMNCompilerConfigurationImpl)DMNFactory.newCompilerConfiguration()));
        try {
            DMNAssemblerService.applyDecisionLogicCompilerFactory((ClassLoader)classLoader, (DMNCompilerConfigurationImpl)dmnCompilerConfiguration);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to initialize DMNCompiler decisionlogicCompilerFactory based on parameters provided", e);
        }
        this.dmnCompilerConfig = dmnCompilerConfiguration;
        this.dmnDTValidator = InternalDMNDTAnalyserFactory.newDMNDTAnalyser(this.dmnProfiles);
    }

    @Override
    public void dispose() {
    }

    public Schema getOverrideSchema() {
        return this.overrideSchema;
    }

    public void setOverrideSchema(Schema overrideSchema) {
        this.overrideSchema = overrideSchema;
    }

    @Override
    public DMNValidator.ValidatorBuilder validateUsing(DMNValidator.Validation ... options) {
        return new ValidatorBuilderImpl(this, options);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel) {
        return this.validate(dmnModel, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)dmnModel, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_NO_XML_SOURCE);
        }
        try {
            this.validateModelCompilation(dmnModel, (DMNMessageManager)results, flags);
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
        }
        return results.getMessages();
    }

    @Override
    public List<DMNMessage> validate(File xmlFile) {
        return this.validate(xmlFile, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(File xmlFile, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
            results.addAll(this.validateSchema(xmlFile));
        }
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
            Definitions dmndefs = null;
            try {
                dmndefs = DMNMarshallerFactory.newMarshallerWithExtensions((List)this.dmnCompilerConfig.getRegisteredExtensions()).unmarshal((Reader)new FileReader(xmlFile));
                dmndefs.normalize();
                this.validateModelCompilation(dmndefs, (DMNMessageManager)results, flags);
            }
            catch (Throwable t) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
            }
        }
        return results.getMessages();
    }

    @Override
    public List<DMNMessage> validate(Reader reader) {
        return this.validate(reader, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Reader reader, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        try {
            String content = DMNValidatorImpl.readContent(reader);
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                results.addAll(this.validateSchema(new StringReader(content)));
            }
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                Definitions dmndefs = DMNValidatorImpl.unmarshalDefinitionsFromReader(this.dmnCompilerConfig, new StringReader(content));
                this.validateModelCompilation(dmndefs, (DMNMessageManager)results, flags);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
        }
        return results.getMessages();
    }

    private static String readContent(Reader reader) throws IOException {
        char[] b = new char[32768];
        StringBuilder content = new StringBuilder();
        int chars = -1;
        while ((chars = reader.read(b)) > 0) {
            content.append(b, 0, chars);
        }
        return content.toString();
    }

    private static Definitions unmarshalDefinitionsFromReader(DMNCompilerConfiguration config, Reader reader) {
        Definitions dmndefs = DMNMarshallerFactory.newMarshallerWithExtensions((List)config.getRegisteredExtensions()).unmarshal(reader);
        dmndefs.normalize();
        return dmndefs;
    }

    private void validateModelCompilation(Definitions dmnModel, DMNMessageManager results, EnumSet<DMNValidator.Validation> flags) {
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL)) {
            results.addAll(this.validateModel(dmnModel, Collections.emptyList()));
        }
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION)) {
            results.addAll(this.validateCompilation(dmnModel));
        }
        if (flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
            results.addAllUnfiltered(this.analyseDT(dmnModel, flags));
        }
    }

    private List<DMNMessage> validateSchema(File xmlFile) {
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try {
            XStreamMarshaller.DMN_VERSION inferDMNVersion = XStreamMarshaller.inferDMNVersion((Reader)new FileReader(xmlFile));
            StreamSource s = new StreamSource(xmlFile);
            switch (inferDMNVersion) {
                case DMN_v1_1: {
                    return this.validateSchema(s, schemav1_1);
                }
                case DMN_v1_2: {
                    return this.validateSchema(s, schemav1_2);
                }
            }
            return this.validateSchema(s, schemav1_3);
        }
        catch (Exception e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e));
            return problems;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DMNMessage> validateSchema(Reader reader) {
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try (BufferedReader buffer = new BufferedReader(reader);){
            String xml = buffer.lines().collect(Collectors.joining("\n"));
            XStreamMarshaller.DMN_VERSION inferDMNVersion = XStreamMarshaller.inferDMNVersion((Reader)new StringReader(xml));
            StreamSource s = new StreamSource(new StringReader(xml));
            switch (inferDMNVersion) {
                case DMN_v1_1: {
                    List<DMNMessage> list = this.validateSchema(s, schemav1_1);
                    return list;
                }
                case DMN_v1_2: {
                    List<DMNMessage> list = this.validateSchema(s, schemav1_2);
                    return list;
                }
            }
            List<DMNMessage> list = this.validateSchema(s, schemav1_3);
            return list;
        }
        catch (Exception e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e));
            return problems;
        }
    }

    private List<DMNMessage> validateSchema(Source s, Schema s2) {
        Schema using = this.overrideSchema != null ? this.overrideSchema : s2;
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try {
            Validator validator = using.newValidator();
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            validator.validate(s);
        }
        catch (IOException | SAXException e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e));
        }
        return problems;
    }

    private List<DMNMessage> validateModel(Definitions dmnModel, List<Definitions> otherModel_Definitions) {
        StatelessKieSession kieSession = dmnModel instanceof KieDMNModelInstrumentedBase ? this.kb11.newStatelessKieSession() : this.kb12.newStatelessKieSession();
        MessageReporter reporter = new MessageReporter();
        kieSession.setGlobal("reporter", (Object)reporter);
        List dmnModelElements = DMNValidatorImpl.allChildren((DMNModelInstrumentedBase)dmnModel).filter(d -> !(d instanceof DecisionService) || !Boolean.parseBoolean((String)d.getAdditionalAttributes().get(new QName("http://www.trisotech.com/2015/triso/modeling", "dynamicDecisionService")))).collect(Collectors.toList());
        BatchExecutionCommand batch = CommandFactory.newBatchExecution(Arrays.asList(CommandFactory.newInsertElements(dmnModelElements, (String)"DEFAULT", (boolean)false, (String)"DEFAULT"), CommandFactory.newInsertElements(otherModel_Definitions, (String)"DMNImports", (boolean)false, (String)"DMNImports")));
        kieSession.execute((Command)batch);
        return reporter.getMessages().getMessages();
    }

    private List<DMNMessage> validateCompilation(Definitions dmnModel) {
        if (dmnModel != null) {
            DMNCompilerImpl compiler = new DMNCompilerImpl(this.dmnCompilerConfig);
            DMNModel model = compiler.compile(dmnModel);
            if (model != null) {
                return model.getMessages();
            }
            throw new IllegalStateException("Compiled model is null!");
        }
        return Collections.emptyList();
    }

    private List<DMNMessage> analyseDT(Definitions dmnModel, Set<DMNValidator.Validation> flags) {
        if (dmnModel != null) {
            DMNCompilerImpl compiler = new DMNCompilerImpl(this.dmnCompilerConfig);
            DMNModel model = compiler.compile(dmnModel);
            if (model != null) {
                List<DTAnalysis> vs = this.dmnDTValidator.analyse(model, flags);
                List<DMNMessage> results = vs.stream().flatMap(a -> a.asDMNMessages().stream()).collect(Collectors.toList());
                return results;
            }
            throw new IllegalStateException("Compiled model is null!");
        }
        return Collections.emptyList();
    }

    private static Stream<DMNModelInstrumentedBase> allChildren(DMNModelInstrumentedBase root) {
        return Stream.concat(Stream.of(root), root.getChildren().stream().flatMap(DMNValidatorImpl::allChildren));
    }

    static {
        try {
            schemav1_1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20151101/dmn.xsd")));
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
        try {
            schemav1_2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DC.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DI.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DMNDI12.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DMN12.xsd"))});
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
        try {
            schemav1_3 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DC.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DI.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DMNDI13.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20191111/DMN13.xsd"))});
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
    }

    public static class ValidatorBuilderImpl
    implements DMNValidator.ValidatorBuilder {
        private final EnumSet<DMNValidator.Validation> flags;
        private final DMNValidatorImpl validator;
        private DMNValidator.ValidatorBuilder.ValidatorImportReaderResolver importResolver;

        public ValidatorBuilderImpl(DMNValidatorImpl dmnValidatorImpl, DMNValidator.Validation[] options) {
            this.validator = dmnValidatorImpl;
            this.flags = EnumSet.copyOf(Arrays.asList(options));
        }

        @Override
        public DMNValidator.ValidatorBuilder usingImports(DMNValidator.ValidatorBuilder.ValidatorImportReaderResolver r) {
            this.importResolver = r;
            return this;
        }

        @Override
        public DMNValidator.ValidatorBuilder usingSchema(Schema r) {
            this.validator.setOverrideSchema(r);
            return this;
        }

        @Override
        public List<DMNMessage> theseModels(File ... files) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
            try {
                Reader[] readers = new Reader[files.length];
                for (int i = 0; i < files.length; ++i) {
                    readers[i] = new FileReader(files[i]);
                }
                results.addAll(this.theseModels(readers));
            }
            catch (Throwable t) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
            }
            return results.getMessages();
        }

        @Override
        public List<DMNMessage> theseModels(Reader ... readers) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
            ArrayList<Definitions> models = new ArrayList<Definitions>();
            for (Reader reader : readers) {
                try {
                    String content = DMNValidatorImpl.readContent(reader);
                    if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                        results.addAll(this.validator.validateSchema(new StringReader(content)));
                    }
                    Definitions dmndefs = DMNValidatorImpl.unmarshalDefinitionsFromReader(this.validator.dmnCompilerConfig, new StringReader(content));
                    models.add(dmndefs);
                }
                catch (Exception t) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
                }
            }
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                if (results.hasErrors()) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.VALIDATION_STOPPED);
                    return results.getMessages();
                }
                this.validateDefinitions(this.internalValidatorSortModels(models), (DMNMessageManager)results);
            }
            return results.getMessages();
        }

        @Override
        public List<DMNMessage> theseModels(Definitions ... models) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_NO_XML_SOURCE);
            }
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                if (results.hasErrors()) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.VALIDATION_STOPPED);
                    return results.getMessages();
                }
                this.validateDefinitions(this.internalValidatorSortModels(Arrays.asList(models)), (DMNMessageManager)results);
            }
            return results.getMessages();
        }

        private void validateDefinitions(List<Definitions> definitions, DMNMessageManager results) {
            ArrayList<Definitions> otherModel_Definitions = new ArrayList<Definitions>();
            ArrayList<DMNModel> otherModel_DMNModels = new ArrayList<DMNModel>();
            for (Definitions dmnModel : definitions) {
                try {
                    DMNModel model;
                    if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL)) {
                        results.addAll(this.validator.validateModel(dmnModel, otherModel_Definitions));
                        otherModel_Definitions.add(dmnModel);
                    }
                    if (!this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) && !this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) continue;
                    DMNCompilerImpl compiler = new DMNCompilerImpl(this.validator.dmnCompilerConfig);
                    Function<String, Reader> relativeResolver = null;
                    if (this.importResolver != null) {
                        relativeResolver = locationURI -> this.importResolver.newReader(dmnModel.getNamespace(), dmnModel.getName(), (String)locationURI);
                    }
                    if ((model = compiler.compile(dmnModel, otherModel_DMNModels, null, relativeResolver)) != null) {
                        results.addAll(model.getMessages());
                        otherModel_DMNModels.add(model);
                        if (!this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) continue;
                        List<DTAnalysis> vs = this.validator.dmnDTValidator.analyse(model, this.flags);
                        List dtAnalysisResults = vs.stream().flatMap(a -> a.asDMNMessages().stream()).collect(Collectors.toList());
                        results.addAllUnfiltered(dtAnalysisResults);
                        continue;
                    }
                    throw new IllegalStateException("Compiled model is null!");
                }
                catch (Throwable t) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
                }
            }
        }

        private List<Definitions> internalValidatorSortModels(List<Definitions> ms) {
            List dmnResources = ms.stream().map(d -> new DMNResource(new QName(d.getNamespace(), d.getName()), null, d)).collect(Collectors.toList());
            DMNAssemblerService.enrichDMNResourcesWithImportsDependencies(dmnResources, Collections.emptyList());
            List sortedDmnResources = DMNResourceDependenciesSorter.sort(dmnResources);
            return sortedDmnResources.stream().map(d -> d.getDefinitions()).collect(Collectors.toList());
        }
    }
}

