/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELProfile;
import org.kie.dmn.feel.lang.ast.ASTNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.BooleanNode;
import org.kie.dmn.feel.lang.ast.FunctionInvocationNode;
import org.kie.dmn.feel.lang.ast.NameRefNode;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.lang.ast.SignedUnaryNode;
import org.kie.dmn.feel.lang.ast.StringNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.ast.visitor.DefaultedVisitor;
import org.kie.dmn.feel.lang.impl.FEELImpl;
import org.kie.dmn.feel.util.EvalHelper;

public class DMNDTAnalyserValueFromNodeVisitor
extends DefaultedVisitor<Comparable<?>> {
    private final FEELImpl FEEL;

    public DMNDTAnalyserValueFromNodeVisitor(List<FEELProfile> feelProfiles) {
        this.FEEL = (FEELImpl)org.kie.dmn.feel.FEEL.newInstance(feelProfiles);
    }

    public Comparable<?> defaultVisit(ASTNode n) {
        throw new UnsupportedOperationException("Gaps/Overlaps analysis cannot be performed for InputEntry with unary test: {}" + n.getText());
    }

    public Boolean visit(BooleanNode n) {
        return n.getValue();
    }

    public BigDecimal visit(NumberNode n) {
        return n.getValue();
    }

    public String visit(StringNode n) {
        return EvalHelper.unescapeString((String)n.getText());
    }

    public Comparable<?> visit(SignedUnaryNode n) {
        BaseNode signedExpr = n.getExpression();
        if (signedExpr instanceof NumberNode) {
            BigDecimal valueFromNode = (BigDecimal)signedExpr.accept((Visitor)this);
            if (n.getSign() == SignedUnaryNode.Sign.NEGATIVE) {
                return BigDecimal.valueOf(-1L).multiply(valueFromNode);
            }
            return valueFromNode;
        }
        return this.defaultVisit((ASTNode)n);
    }

    public Comparable<?> visit(FunctionInvocationNode n) {
        if (((Boolean)n.accept((Visitor)new SupportedConstantValueVisitor())).booleanValue()) {
            return this.blankEvaluate(n);
        }
        return this.defaultVisit((ASTNode)n);
    }

    private Comparable<?> blankEvaluate(FunctionInvocationNode n) {
        return (Comparable)n.evaluate((EvaluationContext)this.FEEL.newEvaluationContext(Collections.emptyList(), Collections.emptyMap()));
    }

    private static class SupportedConstantValueVisitor
    extends DefaultedVisitor<Boolean> {
        private SupportedConstantValueVisitor() {
        }

        public boolean areAllSupported(List<BaseNode> nodes) {
            return nodes.stream().allMatch(n -> (Boolean)n.accept((Visitor)this));
        }

        public Boolean defaultVisit(ASTNode n) {
            return false;
        }

        public Boolean visit(BooleanNode n) {
            return true;
        }

        public Boolean visit(NumberNode n) {
            return true;
        }

        public Boolean visit(StringNode n) {
            return true;
        }

        public Boolean visit(SignedUnaryNode n) {
            BaseNode signedExpr = n.getExpression();
            if (signedExpr instanceof NumberNode) {
                return true;
            }
            return this.defaultVisit((ASTNode)n);
        }

        public Boolean visit(FunctionInvocationNode n) {
            String fnName = null;
            if (n.getName() instanceof NameRefNode) {
                fnName = n.getName().getText();
            }
            if (fnName == null) {
                throw new IllegalStateException("Name of function is not instance of NameRefNode!" + n.toString());
            }
            List params = n.getParams().getElements();
            switch (fnName) {
                case "date": {
                    if (params.size() != 1 && params.size() != 3) break;
                    return this.areAllSupported(params);
                }
                case "date and time": {
                    if (params.size() != 2 && params.size() != 1) break;
                    return this.areAllSupported(params);
                }
                case "time": {
                    if (params.size() != 1 && params.size() != 4) break;
                    return this.areAllSupported(params);
                }
                case "number": {
                    if (params.size() != 3) break;
                    return this.areAllSupported(params);
                }
                case "string": {
                    if (params.size() != 1) break;
                    return this.areAllSupported(params);
                }
                case "duration": {
                    if (params.size() == 1) {
                        return this.areAllSupported(params);
                    }
                }
                case "years and months duration": {
                    if (params.size() == 2) {
                        return this.areAllSupported(params);
                    }
                }
                default: {
                    return false;
                }
            }
            return false;
        }
    }

    public static class DMNDTAnalyserOutputClauseVisitor
    extends DMNDTAnalyserValueFromNodeVisitor {
        public DMNDTAnalyserOutputClauseVisitor(List<FEELProfile> feelProfiles) {
            super(feelProfiles);
        }

        @Override
        public Comparable<?> defaultVisit(ASTNode n) {
            return n.getText();
        }
    }
}

