/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.drools.core.util.Drools;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.kie.dmn.core.util.DefaultDMNMessagesManager;
import org.kie.dmn.core.util.KieHelper;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.MessageReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DMNValidatorImpl
implements DMNValidator {
    public static final Logger LOG = LoggerFactory.getLogger(DMNValidatorImpl.class);
    static Schema schema;
    private Optional<KieContainer> kieContainer;
    private List<DMNMessage> failedInitMsg = new ArrayList<DMNMessage>();

    public DMNValidatorImpl() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "kie-dmn-validation", Drools.getFullVersion()), (Resource[])new Resource[]{ks.getResources().newClassPathResource("dmn-validation-rules.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-auth-req.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-bkm.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-business-context.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-context.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-decision.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-dmnelementref.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-dtable.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-info-req.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-inputdata.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-know-req.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-know-source.drl", this.getClass()), ks.getResources().newClassPathResource("dmn-validation-rules-typeref.drl", this.getClass())});
        if (kieContainer != null) {
            this.kieContainer = Optional.of(kieContainer);
        } else {
            this.kieContainer = Optional.empty();
            LOG.error("Unable to load embedded DMN validation rules file.");
            String message = MsgUtil.createMessage((Msg.Message0)Msg.FAILED_VALIDATOR);
            this.failedInitMsg.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, message, Msg.FAILED_VALIDATOR.getType(), null));
        }
    }

    @Override
    public void dispose() {
        this.kieContainer.ifPresent(KieContainer::dispose);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel) {
        return this.validate(dmnModel, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)dmnModel, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_NO_XML_SOURCE);
        }
        try {
            this.validateModelCompilation(dmnModel, (DMNMessageManager)results, flags);
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)dmnModel, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message0)Msg.FAILED_VALIDATOR);
        }
        return results.getMessages();
    }

    @Override
    public List<DMNMessage> validate(File xmlFile) {
        return this.validate(xmlFile, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(File xmlFile, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
            results.addAll(this.validateSchema(xmlFile));
        }
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION)) {
            Definitions dmndefs = null;
            try {
                dmndefs = DMNMarshallerFactory.newDefaultMarshaller().unmarshal((Reader)new FileReader(xmlFile));
                this.validateModelCompilation(dmndefs, (DMNMessageManager)results, flags);
            }
            catch (Throwable t) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message0)Msg.FAILED_VALIDATOR);
            }
        }
        return results.getMessages();
    }

    @Override
    public List<DMNMessage> validate(Reader reader) {
        return this.validate(reader, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Reader reader, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        try {
            String content = this.readContent(reader);
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                results.addAll(this.validateSchema(new StringReader(content)));
            }
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION)) {
                Definitions dmndefs = DMNMarshallerFactory.newDefaultMarshaller().unmarshal((Reader)new StringReader(content));
                this.validateModelCompilation(dmndefs, (DMNMessageManager)results, flags);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message0)Msg.FAILED_VALIDATOR);
        }
        return results.getMessages();
    }

    private String readContent(Reader reader) throws IOException {
        char[] b = new char[32768];
        StringBuilder content = new StringBuilder();
        int chars = -1;
        while ((chars = reader.read(b)) > 0) {
            content.append(b, 0, chars);
        }
        return content.toString();
    }

    private void validateModelCompilation(Definitions dmnModel, DMNMessageManager results, EnumSet<DMNValidator.Validation> flags) {
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL)) {
            results.addAll(this.validateModel(dmnModel));
        }
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION)) {
            results.addAll(this.validateCompilation(dmnModel, results));
        }
    }

    private List<DMNMessage> validateSchema(File xmlFile) {
        StreamSource s = new StreamSource(xmlFile);
        return this.validateSchema(s);
    }

    private List<DMNMessage> validateSchema(Reader reader) {
        StreamSource s = new StreamSource(reader);
        return this.validateSchema(s);
    }

    private List<DMNMessage> validateSchema(Source s) {
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try {
            schema.newValidator().validate(s);
        }
        catch (IOException | SAXException e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e));
            this.logDebugMessages(problems);
        }
        return problems;
    }

    private List<DMNMessage> validateModel(Definitions dmnModel) {
        if (!this.kieContainer.isPresent()) {
            return this.failedInitMsg;
        }
        StatelessKieSession kieSession = this.kieContainer.get().newStatelessKieSession();
        MessageReporter reporter = new MessageReporter();
        kieSession.setGlobal("reporter", (Object)reporter);
        kieSession.execute((Iterable)DMNValidatorImpl.allChildren((DMNModelInstrumentedBase)dmnModel).collect(Collectors.toList()));
        return reporter.getMessages().getMessages();
    }

    private List<DMNMessage> validateCompilation(Definitions dmnModel, DMNMessageManager results) {
        if (dmnModel != null) {
            DMNCompilerImpl compiler = new DMNCompilerImpl();
            DMNModel model = compiler.compile(dmnModel);
            if (model != null) {
                return model.getMessages();
            }
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)dmnModel, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_VALIDATOR);
        }
        return Collections.emptyList();
    }

    private static Stream<DMNModelInstrumentedBase> allChildren(DMNModelInstrumentedBase root) {
        return Stream.concat(Stream.of(root), root.getChildren().stream().flatMap(DMNValidatorImpl::allChildren));
    }

    private void logDebugMessages(List<DMNMessage> messages) {
        if (LOG.isDebugEnabled()) {
            for (DMNMessage m : messages) {
                LOG.debug("{}", (Object)m);
            }
        }
    }

    static {
        try {
            schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

