/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.Collections;
import java.util.List;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.Domain;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class DDTAInputClause
implements Domain {
    private final Interval domainMinMax;
    private final List discreteValues;

    public DDTAInputClause(Interval domainMinMax) {
        this.domainMinMax = domainMinMax;
        this.discreteValues = Collections.emptyList();
    }

    public DDTAInputClause(Interval domainMinMax, List discreteValues) {
        this.domainMinMax = domainMinMax;
        this.discreteValues = discreteValues;
    }

    @Override
    public Bound<?> getMin() {
        return this.domainMinMax.getLowerBound();
    }

    @Override
    public Bound<?> getMax() {
        return this.domainMinMax.getUpperBound();
    }

    @Override
    public Interval getDomainMinMax() {
        return this.domainMinMax;
    }

    @Override
    public List getDiscreteValues() {
        return Collections.unmodifiableList(this.discreteValues);
    }

    @Override
    public boolean isDiscreteDomain() {
        return this.discreteValues != null && !this.discreteValues.isEmpty();
    }
}

