/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.drools.core.util.Drools;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.backend.marshalling.v1x.XStreamMarshaller;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.assembler.DMNResource;
import org.kie.dmn.core.assembler.DMNResourceDependenciesSorter;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.kie.dmn.core.util.DefaultDMNMessagesManager;
import org.kie.dmn.core.util.KieHelper;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.util.ClassLoaderUtil;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.kie.dmn.validation.DMNValidator;
import org.kie.dmn.validation.MessageReporter;
import org.kie.dmn.validation.dtanalysis.DMNDTAnalyser;
import org.kie.dmn.validation.dtanalysis.model.DTAnalysis;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DMNValidatorImpl
implements DMNValidator {
    public static final Logger LOG = LoggerFactory.getLogger(DMNValidatorImpl.class);
    static final Schema schemav1_1;
    static final Schema schemav1_2;
    private Optional<KieContainer> kieContainer;
    private List<DMNMessage> failedInitMsg = new ArrayList<DMNMessage>();
    private final List<DMNProfile> dmnProfiles = new ArrayList<DMNProfile>();
    private final DMNCompilerConfiguration dmnCompilerConfig;
    private final DMNDTAnalyser dmnDTValidator;

    public DMNValidatorImpl(List<DMNProfile> dmnProfiles) {
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "kie-dmn-validation", Drools.getFullVersion()), (Resource[])new Resource[]{ks.getResources().newReaderResource((Reader)new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://www.drools.org/xsd/kmodule\">\n  <kbase name=\"kbase_DMNv1x\" default=\"false\" packages=\"org.kie.dmn.validation.DMNv1x\" />\n  <kbase name=\"kbase_DMNv1_1\" default=\"false\" includes=\"kbase_DMNv1x\" packages=\"org.kie.dmn.validation.DMNv1_1\">\n    <ksession name=\"ksession_DMNv1_1\" default=\"false\" type=\"stateless\"/>\n  </kbase>\n  <kbase name=\"kbase_DMNv1_2\" default=\"false\" includes=\"kbase_DMNv1x\" packages=\"org.kie.dmn.validation.DMNv1_2\">\n    <ksession name=\"ksession_DMNv1_2\" default=\"false\" type=\"stateless\"/>\n  </kbase>\n</kmodule>")).setTargetPath("META-INF/kmodule.xml"), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-auth-req.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-bkm.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-business-context.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-context.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-decision.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-dmnelementref.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-dtable.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-info-req.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-inputdata.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-know-req.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1x/dmn-validation-rules-know-source.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1_1/dmn-validation-rules-typeref.drl", this.getClass()), ks.getResources().newClassPathResource("org/kie/dmn/validation/DMNv1_2/dmn-validation-rules-typeref.drl", this.getClass())});
        if (kieContainer != null) {
            if (LOG.isDebugEnabled()) {
                for (String kbName : kieContainer.getKieBaseNames()) {
                    KieBase kieBase = kieContainer.getKieBase(kbName);
                    LOG.debug("KieBase: {}", (Object)kbName);
                    kieBase.getKiePackages().stream().flatMap(kp -> kp.getRules().stream()).map(r -> r.getPackageName() + " " + r.getName()).forEach(x -> LOG.debug("  {}", x));
                }
            }
            this.kieContainer = Optional.of(kieContainer);
        } else {
            this.kieContainer = Optional.empty();
            LOG.error("Unable to load embedded DMN validation rules file.");
            String message = MsgUtil.createMessage((Msg.Message0)Msg.FAILED_VALIDATOR);
            this.failedInitMsg.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, message, Msg.FAILED_VALIDATOR.getType(), null));
        }
        ChainedProperties localChainedProperties = new ChainedProperties();
        this.dmnProfiles.addAll(DMNAssemblerService.getDefaultDMNProfiles((ChainedProperties)localChainedProperties));
        this.dmnProfiles.addAll(dmnProfiles);
        ClassLoader classLoader = this.kieContainer.isPresent() ? this.kieContainer.get().getClassLoader() : ClassLoaderUtil.findDefaultClassLoader();
        this.dmnCompilerConfig = DMNAssemblerService.compilerConfigWithKModulePrefs((ClassLoader)classLoader, (ChainedProperties)localChainedProperties, this.dmnProfiles, (DMNCompilerConfigurationImpl)((DMNCompilerConfigurationImpl)DMNFactory.newCompilerConfiguration()));
        this.dmnDTValidator = new DMNDTAnalyser(this.dmnProfiles);
    }

    @Override
    public void dispose() {
        this.kieContainer.ifPresent(KieContainer::dispose);
    }

    @Override
    public DMNValidator.ValidatorBuilder validateUsing(DMNValidator.Validation ... options) {
        return new ValidatorBuilderImpl(this, options);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel) {
        return this.validate(dmnModel, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Definitions dmnModel, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)dmnModel, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_NO_XML_SOURCE);
        }
        try {
            this.validateModelCompilation(dmnModel, (DMNMessageManager)results, flags);
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
        }
        return results.getMessages();
    }

    @Override
    public List<DMNMessage> validate(File xmlFile) {
        return this.validate(xmlFile, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(File xmlFile, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
            results.addAll(this.validateSchema(xmlFile));
        }
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
            Definitions dmndefs = null;
            try {
                dmndefs = DMNMarshallerFactory.newMarshallerWithExtensions((List)this.dmnCompilerConfig.getRegisteredExtensions()).unmarshal((Reader)new FileReader(xmlFile));
                dmndefs.normalize();
                this.validateModelCompilation(dmndefs, (DMNMessageManager)results, flags);
            }
            catch (Throwable t) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
            }
        }
        return results.getMessages();
    }

    @Override
    public List<DMNMessage> validate(Reader reader) {
        return this.validate(reader, DMNValidator.Validation.VALIDATE_MODEL);
    }

    @Override
    public List<DMNMessage> validate(Reader reader, DMNValidator.Validation ... options) {
        DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
        EnumSet<DMNValidator.Validation> flags = EnumSet.copyOf(Arrays.asList(options));
        try {
            String content = DMNValidatorImpl.readContent(reader);
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                results.addAll(this.validateSchema(new StringReader(content)));
            }
            if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                Definitions dmndefs = DMNMarshallerFactory.newMarshallerWithExtensions((List)this.dmnCompilerConfig.getRegisteredExtensions()).unmarshal((Reader)new StringReader(content));
                dmndefs.normalize();
                this.validateModelCompilation(dmndefs, (DMNMessageManager)results, flags);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
        }
        return results.getMessages();
    }

    private static String readContent(Reader reader) throws IOException {
        char[] b = new char[32768];
        StringBuilder content = new StringBuilder();
        int chars = -1;
        while ((chars = reader.read(b)) > 0) {
            content.append(b, 0, chars);
        }
        return content.toString();
    }

    private void validateModelCompilation(Definitions dmnModel, DMNMessageManager results, EnumSet<DMNValidator.Validation> flags) {
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL)) {
            results.addAll(this.validateModel(dmnModel, Collections.emptyList()));
        }
        if (flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION)) {
            results.addAll(this.validateCompilation(dmnModel));
        }
        if (flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
            results.addAllUnfiltered(this.validateDT(dmnModel));
        }
    }

    private List<DMNMessage> validateSchema(File xmlFile) {
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try {
            XStreamMarshaller.DMN_VERSION inferDMNVersion = XStreamMarshaller.inferDMNVersion((Reader)new FileReader(xmlFile));
            StreamSource s = new StreamSource(xmlFile);
            return inferDMNVersion == XStreamMarshaller.DMN_VERSION.DMN_v1_1 ? this.validateSchema(s, schemav1_1) : this.validateSchema(s, schemav1_2);
        }
        catch (Exception e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e));
            return problems;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<DMNMessage> validateSchema(Reader reader) {
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try (BufferedReader buffer = new BufferedReader(reader);){
            String xml = buffer.lines().collect(Collectors.joining("\n"));
            XStreamMarshaller.DMN_VERSION inferDMNVersion = XStreamMarshaller.inferDMNVersion((Reader)new StringReader(xml));
            StreamSource s = new StreamSource(new StringReader(xml));
            List<DMNMessage> list = inferDMNVersion == XStreamMarshaller.DMN_VERSION.DMN_v1_1 ? this.validateSchema(s, schemav1_1) : this.validateSchema(s, schemav1_2);
            return list;
        }
        catch (Exception e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e));
            return problems;
        }
    }

    private List<DMNMessage> validateSchema(Source s, Schema schema) {
        ArrayList<DMNMessage> problems = new ArrayList<DMNMessage>();
        try {
            schema.newValidator().validate(s);
        }
        catch (IOException | SAXException e) {
            problems.add((DMNMessage)new DMNMessageImpl(DMNMessage.Severity.ERROR, MsgUtil.createMessage((Msg.Message1)Msg.FAILED_XML_VALIDATION, (Object)e.getMessage()), Msg.FAILED_XML_VALIDATION.getType(), null, (Throwable)e));
            this.logDebugMessages(problems);
        }
        return problems;
    }

    private List<DMNMessage> validateModel(Definitions dmnModel, List<Definitions> otherModel_Definitions) {
        if (!this.kieContainer.isPresent()) {
            return this.failedInitMsg;
        }
        String kieSessionName = "ksession_DMNv1_2";
        if (dmnModel instanceof KieDMNModelInstrumentedBase) {
            kieSessionName = "ksession_DMNv1_1";
        }
        StatelessKieSession kieSession = this.kieContainer.get().newStatelessKieSession(kieSessionName);
        MessageReporter reporter = new MessageReporter();
        kieSession.setGlobal("reporter", (Object)reporter);
        List dmnModelElements = DMNValidatorImpl.allChildren((DMNModelInstrumentedBase)dmnModel).collect(Collectors.toList());
        BatchExecutionCommand batch = CommandFactory.newBatchExecution(Arrays.asList(CommandFactory.newInsertElements(dmnModelElements, (String)"DEFAULT", (boolean)false, (String)"DEFAULT"), CommandFactory.newInsertElements(otherModel_Definitions, (String)"DMNImports", (boolean)false, (String)"DMNImports")));
        kieSession.execute((Command)batch);
        return reporter.getMessages().getMessages();
    }

    private List<DMNMessage> validateCompilation(Definitions dmnModel) {
        if (dmnModel != null) {
            DMNCompilerImpl compiler = new DMNCompilerImpl(this.dmnCompilerConfig);
            DMNModel model = compiler.compile(dmnModel);
            if (model != null) {
                return model.getMessages();
            }
            throw new IllegalStateException("Compiled model is null!");
        }
        return Collections.emptyList();
    }

    private List<DMNMessage> validateDT(Definitions dmnModel) {
        if (dmnModel != null) {
            DMNCompilerImpl compiler = new DMNCompilerImpl(this.dmnCompilerConfig);
            DMNModel model = compiler.compile(dmnModel);
            if (model != null) {
                List<DTAnalysis> vs = this.dmnDTValidator.analyse(model);
                List<DMNMessage> results = vs.stream().flatMap(a -> a.asDMNMessages().stream()).collect(Collectors.toList());
                return results;
            }
            throw new IllegalStateException("Compiled model is null!");
        }
        return Collections.emptyList();
    }

    private static Stream<DMNModelInstrumentedBase> allChildren(DMNModelInstrumentedBase root) {
        return Stream.concat(Stream.of(root), root.getChildren().stream().flatMap(DMNValidatorImpl::allChildren));
    }

    private void logDebugMessages(List<DMNMessage> messages) {
        if (LOG.isDebugEnabled()) {
            for (DMNMessage m : messages) {
                LOG.debug("{}", (Object)m);
            }
        }
    }

    static {
        try {
            schemav1_1 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20151101/dmn.xsd")));
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
        try {
            schemav1_2 = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new Source[]{new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DC.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DI.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DMNDI12.xsd")), new StreamSource(DMNValidatorImpl.class.getResourceAsStream("org/omg/spec/DMN/20180521/DMN12.xsd"))});
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to initialize correctly DMNValidator.", e);
        }
    }

    public static class ValidatorBuilderImpl
    implements DMNValidator.ValidatorBuilder {
        private final EnumSet<DMNValidator.Validation> flags;
        private final DMNValidatorImpl validator;

        public ValidatorBuilderImpl(DMNValidatorImpl dmnValidatorImpl, DMNValidator.Validation[] options) {
            this.validator = dmnValidatorImpl;
            this.flags = EnumSet.copyOf(Arrays.asList(options));
        }

        @Override
        public List<DMNMessage> theseModels(File ... files) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
            try {
                Reader[] readers = new Reader[files.length];
                for (int i = 0; i < files.length; ++i) {
                    readers[i] = new FileReader(files[i]);
                }
                results.addAll(this.theseModels(readers));
            }
            catch (Throwable t) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
            }
            return results.getMessages();
        }

        @Override
        public List<DMNMessage> theseModels(Reader ... readers) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                for (Reader reader : readers) {
                    results.addAll(this.validator.validateSchema(reader));
                }
            }
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                if (results.hasErrors()) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.VALIDATION_STOPPED);
                    return results.getMessages();
                }
                List<Definitions> models = this.unmarshallReaders(readers);
                this.validateDefinitions(this.internalValidatorSortModels(models), (DMNMessageManager)results);
            }
            return results.getMessages();
        }

        @Override
        public List<DMNMessage> theseModels(Definitions ... models) {
            DefaultDMNMessagesManager results = new DefaultDMNMessagesManager();
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_SCHEMA)) {
                MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.FAILED_NO_XML_SOURCE);
            }
            if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL) || this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) || this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) {
                if (results.hasErrors()) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, null, null, (Msg.Message0)Msg.VALIDATION_STOPPED);
                    return results.getMessages();
                }
                this.validateDefinitions(this.internalValidatorSortModels(Arrays.asList(models)), (DMNMessageManager)results);
            }
            return results.getMessages();
        }

        private List<Definitions> unmarshallReaders(Reader ... readers) {
            ArrayList<Definitions> models = new ArrayList<Definitions>();
            for (Reader reader : readers) {
                Definitions dmndefs = DMNMarshallerFactory.newMarshallerWithExtensions((List)this.validator.dmnCompilerConfig.getRegisteredExtensions()).unmarshal(reader);
                dmndefs.normalize();
                models.add(dmndefs);
            }
            return models;
        }

        private void validateDefinitions(List<Definitions> definitions, DMNMessageManager results) {
            ArrayList<Definitions> otherModel_Definitions = new ArrayList<Definitions>();
            ArrayList<DMNModel> otherModel_DMNModels = new ArrayList<DMNModel>();
            for (Definitions dmnModel : definitions) {
                try {
                    if (this.flags.contains((Object)DMNValidator.Validation.VALIDATE_MODEL)) {
                        results.addAll(this.validator.validateModel(dmnModel, otherModel_Definitions));
                        otherModel_Definitions.add(dmnModel);
                    }
                    if (!this.flags.contains((Object)DMNValidator.Validation.VALIDATE_COMPILATION) && !this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) continue;
                    DMNCompilerImpl compiler = new DMNCompilerImpl(this.validator.dmnCompilerConfig);
                    DMNModel model = compiler.compile(dmnModel, otherModel_DMNModels);
                    if (model != null) {
                        results.addAll(model.getMessages());
                        otherModel_DMNModels.add(model);
                        if (!this.flags.contains((Object)DMNValidator.Validation.ANALYZE_DECISION_TABLE)) continue;
                        List<DTAnalysis> vs = this.validator.dmnDTValidator.analyse(model);
                        List dtAnalysisResults = vs.stream().flatMap(a -> a.asDMNMessages().stream()).collect(Collectors.toList());
                        results.addAll(dtAnalysisResults);
                        continue;
                    }
                    throw new IllegalStateException("Compiled model is null!");
                }
                catch (Throwable t) {
                    MsgUtil.reportMessage((Logger)LOG, (DMNMessage.Severity)DMNMessage.Severity.ERROR, null, (DMNMessageManager)results, (Throwable)t, null, (Msg.Message1)Msg.VALIDATION_RUNTIME_PROBLEM, (Object)t.getMessage());
                }
            }
        }

        private List<Definitions> internalValidatorSortModels(List<Definitions> ms) {
            List dmnResources = ms.stream().map(d -> new DMNResource(new QName(d.getNamespace(), d.getName()), null, d)).collect(Collectors.toList());
            DMNAssemblerService.enrichDMNResourcesWithImportsDependencies(dmnResources, Collections.emptyList());
            List sortedDmnResources = DMNResourceDependenciesSorter.sort(dmnResources);
            return sortedDmnResources.stream().map(d -> d.getDefinitions()).collect(Collectors.toList());
        }
    }
}

