/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.dtanalysis.model.Bound;
import org.kie.dmn.validation.dtanalysis.model.BoundValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interval {
    private static final Logger LOG = LoggerFactory.getLogger(Interval.class);
    public static final Comparable<?> POS_INF = new Comparable<Object>(){

        @Override
        public int compareTo(Object o) {
            return o == this ? 0 : 1;
        }

        public String toString() {
            return "+Inf";
        }
    };
    public static final Comparable<?> NEG_INF = new Comparable<Object>(){

        @Override
        public int compareTo(Object o) {
            return o == this ? 0 : -1;
        }

        public String toString() {
            return "-Inf";
        }
    };
    private final Bound<?> lowerBound;
    private final Bound<?> upperBound;
    private final int rule;
    private final int col;

    public Interval(Range.RangeBoundary lowBoundary, Comparable<?> start, Comparable<?> end, Range.RangeBoundary highBoundary, int rule, int col) {
        this.lowerBound = new Bound(start, lowBoundary, this);
        this.upperBound = new Bound(end, highBoundary, this);
        this.rule = rule;
        this.col = col;
    }

    private Interval(Bound<?> lowerBound, Bound<?> upperBound) {
        this.lowerBound = new Bound(lowerBound.getValue(), lowerBound.getBoundaryType(), this);
        this.upperBound = new Bound(upperBound.getValue(), upperBound.getBoundaryType(), this);
        this.rule = 0;
        this.col = 0;
    }

    public static Interval newFromBounds(Bound<?> lowerBound, Bound<?> upperBound) {
        return new Interval(lowerBound, upperBound);
    }

    public String toString() {
        return (this.lowerBound.getBoundaryType() == Range.RangeBoundary.OPEN ? "(" : "[") + " " + Bound.boundValueToString(this.lowerBound.getValue()) + " .. " + Bound.boundValueToString(this.upperBound.getValue()) + " " + (this.upperBound.getBoundaryType() == Range.RangeBoundary.OPEN ? ")" : "]");
    }

    public Bound<?> getLowerBound() {
        return this.lowerBound;
    }

    public Bound<?> getUpperBound() {
        return this.upperBound;
    }

    public int getRule() {
        return this.rule;
    }

    public int getCol() {
        return this.col;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lowerBound == null ? 0 : this.lowerBound.hashCode());
        result = 31 * result + (this.upperBound == null ? 0 : this.upperBound.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.lowerBound == null ? other.lowerBound != null : !this.lowerBound.equals(other.lowerBound)) {
            return false;
        }
        return !(this.upperBound == null ? other.upperBound != null : !this.upperBound.equals(other.upperBound));
    }

    public boolean includes(Interval o) {
        return this.lowerBound.compareTo(o.lowerBound) <= 0 && this.upperBound.compareTo(o.upperBound) >= 0;
    }

    public boolean leftAdjOrOverlap(Interval o) {
        boolean thisLeftLower = this.lowerBound.compareTo(o.lowerBound) <= 0;
        boolean oRightHigher = o.upperBound.compareTo(this.upperBound) >= 0;
        boolean chained = BoundValueComparator.compareValueDispatchingToInf(o.lowerBound, this.upperBound) < 0;
        boolean adj = Bound.adOrOver(o.lowerBound, this.upperBound);
        return thisLeftLower && oRightHigher && (chained || adj);
    }

    public static Range.RangeBoundary invertBoundary(Range.RangeBoundary b) {
        if (b == Range.RangeBoundary.OPEN) {
            return Range.RangeBoundary.CLOSED;
        }
        if (b == Range.RangeBoundary.CLOSED) {
            return Range.RangeBoundary.OPEN;
        }
        throw new IllegalStateException("invertBoundary for: " + b);
    }

    public static List<Interval> flatten(List<Interval> intervals) {
        ArrayList<Interval> results = new ArrayList<Interval>();
        LOG.debug("intervals {}", intervals);
        List bounds = intervals.stream().flatMap(i -> Stream.of(i.getLowerBound(), i.getUpperBound())).collect(Collectors.toList());
        Collections.sort(bounds);
        LOG.debug("bounds (sorted) {}", bounds);
        ArrayDeque<Bound> stack = new ArrayDeque<Bound>();
        Interval candidate = null;
        for (Bound cur : bounds) {
            if (stack.isEmpty() && !cur.isLowerBound()) {
                throw new RuntimeException("Inconsistent sort of bounds.");
            }
            if (cur.isLowerBound()) {
                if (candidate == null) {
                    stack.push(cur);
                    continue;
                }
                if (Bound.adOrOver(candidate.upperBound, cur)) {
                    stack.push(candidate.lowerBound);
                    candidate = null;
                    continue;
                }
                results.add(candidate);
                stack.push(cur);
                continue;
            }
            if (cur.isUpperBound()) {
                Bound pop = (Bound)stack.pop();
                if (!stack.isEmpty()) continue;
                candidate = Interval.newFromBounds(pop, cur);
                continue;
            }
            throw new RuntimeException("Inconsistent value for bounds.");
        }
        if (candidate != null) {
            results.add(candidate);
        }
        LOG.debug("results {}", results);
        return results;
    }

    public static List<Interval> invertOverDomain(Interval interval, Interval domain) {
        ArrayList<Interval> results = new ArrayList<Interval>();
        if (!domain.lowerBound.equals(interval.lowerBound)) {
            Interval left = new Interval(domain.lowerBound.getBoundaryType(), (Comparable<?>)domain.lowerBound.getValue(), (Comparable<?>)interval.lowerBound.getValue(), Interval.invertBoundary(interval.lowerBound.getBoundaryType()), interval.rule, interval.col);
            results.add(left);
        }
        if (!domain.upperBound.equals(interval.upperBound)) {
            Interval right = new Interval(Interval.invertBoundary(interval.upperBound.getBoundaryType()), (Comparable<?>)interval.upperBound.getValue(), (Comparable<?>)domain.upperBound.getValue(), domain.upperBound.getBoundaryType(), interval.rule, interval.col);
            results.add(right);
        }
        LOG.debug("results {}", results);
        return results;
    }
}

