/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.validation.dtanalysis.model;

import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.validation.dtanalysis.model.BoundValueComparator;
import org.kie.dmn.validation.dtanalysis.model.Interval;

public class Bound<V extends Comparable<V>>
implements Comparable<Bound<V>> {
    private final V value;
    private final Range.RangeBoundary boundaryType;
    private final Interval parent;

    public Bound(V value, Range.RangeBoundary boundaryType, Interval parent) {
        this.value = value;
        this.boundaryType = boundaryType;
        this.parent = parent;
    }

    @Override
    public int compareTo(Bound<V> o) {
        int valueCompare = BoundValueComparator.compareValueDispatchingToInf(this, o);
        if (valueCompare != 0) {
            return valueCompare;
        }
        if (this.parent != null && o.parent != null) {
            if (this.isLowerBound() && o.isLowerBound() && this.boundaryType == o.boundaryType) {
                return 0;
            }
            if (this.isUpperBound() && o.isUpperBound() && this.boundaryType == o.boundaryType) {
                return 0;
            }
            if (this.isUpperBound() && this.boundaryType == Range.RangeBoundary.OPEN) {
                return -1;
            }
            if (this.isLowerBound() && this.boundaryType == Range.RangeBoundary.OPEN) {
                return 1;
            }
            if (this.isUpperBound() && this.boundaryType == Range.RangeBoundary.CLOSED) {
                if (o.isLowerBound()) {
                    if (o.boundaryType == Range.RangeBoundary.CLOSED) {
                        return 1;
                    }
                    return -1;
                }
                return 1;
            }
            if (this.isLowerBound() && this.boundaryType == Range.RangeBoundary.CLOSED) {
                if (o.isUpperBound()) {
                    if (o.boundaryType == Range.RangeBoundary.CLOSED) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
        }
        if (this.boundaryType == o.boundaryType) {
            return 0;
        }
        if (this.boundaryType == Range.RangeBoundary.OPEN) {
            return -1;
        }
        return 1;
    }

    public V getValue() {
        return this.value;
    }

    public Range.RangeBoundary getBoundaryType() {
        return this.boundaryType;
    }

    public Interval getParent() {
        return this.parent;
    }

    public boolean isLowerBound() {
        return this.parent.getLowerBound() == this;
    }

    public boolean isUpperBound() {
        return this.parent.getUpperBound() == this;
    }

    public String toString() {
        if (this.isLowerBound()) {
            return (this.boundaryType == Range.RangeBoundary.OPEN ? "(" : "[") + this.value;
        }
        return this.value + (this.boundaryType == Range.RangeBoundary.OPEN ? ")" : "]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundaryType == null ? 0 : this.boundaryType.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bound other = (Bound)obj;
        if (this.boundaryType != other.boundaryType) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static boolean adOrOver(Bound<?> left, Bound<?> right) {
        boolean isValueEqual = left.getValue().equals(right.getValue());
        boolean isBothOpen = left.getBoundaryType() == Range.RangeBoundary.OPEN && right.getBoundaryType() == Range.RangeBoundary.OPEN;
        return isValueEqual && !isBothOpen;
    }

    public static String boundValueToString(Comparable<?> value) {
        return value instanceof String ? "\"" + value + "\"" : value.toString();
    }
}

